package com.crawler.social.utils;

import com.belerweb.social.bean.Result;
import com.belerweb.social.weibo.api.Weibo;
import com.belerweb.social.weibo.bean.AccessToken;
import com.belerweb.social.weibo.bean.User;
import com.crawler.social.beans.WeiboAccessToken;
import com.crawler.social.beans.WeiboUser;
import com.crawler.social.config.WeiboConstant;

/**
 * 微博工具
 * @author rubekid
 *
 * 2017年10月14日 下午7:32:54
 */
public class WeiboUtils {

	/**
	 * 根据code获取 Token
	 * @param clientId
	 * @param clientSecret
	 * @param redirectUri
	 * @param code
	 * @return
	 */
	public static WeiboAccessToken getAccessToken(String clientId, String clientSecret, String redirectUri, String code){
		Weibo weibo = new Weibo(clientId, clientSecret, redirectUri);
		return getAccessToken(weibo, code);
	}
	
	/**
	 *  根据code获取 Token
	 * @param code
	 * @return
	 */
	public static WeiboAccessToken getAccessToken(String code){
		return getAccessToken(getWeibo(), code);
	}
	
	/**
	 *  根据code获取 Token
	 * @param code
	 * @return
	 */
	public static WeiboAccessToken getAccessToken(Weibo weibo, String code){
		Result<AccessToken> result = weibo.getOAuth2().accessToken(code);
		return BeanUtils.transfer(result.getResult(), WeiboAccessToken.class);
	}
	
	/**
	 * 获取
	 * @param clientId
	 * @param clientSecret
	 * @param redirectUri
	 * @param accessToken
	 * @param uid
	 * @return
	 */
	public static WeiboUser getUserInfo(String clientId, String clientSecret, String redirectUri, String accessToken, String uid){
		Weibo weibo = new Weibo(clientId, clientSecret, redirectUri);
		return getUserInfo(weibo, accessToken, uid);
	}
	
	public static WeiboUser getUserInfo(String accessToken, String uid){
		return getUserInfo(getWeibo(), accessToken, uid);
	}
	/**
	 * 获取微博用户
	 * @param weibo
	 * @param accessToken
	 * @param uid
	 * @return
	 */
	public static WeiboUser getUserInfo(Weibo weibo, String accessToken,  String uid){
		Result<User> result = weibo.getUser().show(weibo.getClientId(), accessToken, uid, null);
		return BeanUtils.transfer(result.getResult(), WeiboUser.class);
	}
	
	/**
	 * 获取微博对象
	 * @return
	 */
	public static Weibo getWeibo(){
		return new Weibo(WeiboConstant.CLIENT_ID, WeiboConstant.CLIENT_SECRET, WeiboConstant.REDIRECT_URI);
	}
	
	/**
	 * 获取微博对象
	 * @param clientId
	 * @param clientSecret
	 * @param redirectUri
	 * @return
	 */
	public static Weibo getWeibo(String clientId, String clientSecret, String redirectUri){
		return new Weibo(clientId, clientSecret, redirectUri);
	}
	
}
