package com.crawler.weixin.common;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

import org.apache.commons.codec.binary.Hex;

/**
 * 字符串工具
 * @author rubekid
 *
 * 2017年10月14日 下午1:26:10
 */
public class StringUtils {

	private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	
	/**
	 * 获取指定长度随机字符串
	 * 
	 * @param length
	 * @return
	 */
	public static String getRandomString(int length) {
		StringBuffer sb = new StringBuffer();
		Random random = new Random();
		int len = CHARS.length();
		for (int i = 0; i < length; i++) {
			int index = random.nextInt(len);
			index = index % length;
			sb.append(CHARS.charAt(index));
		}
		return sb.toString();
	}
	

	/**
	 * 获取随机数字字符串
	 * 
	 * @param length
	 * @return
	 */
	public static String getRandomNumString(int length) {
		if (length <= 0) {
			return "";
		}

		char[] chars = ("0123456789").toCharArray();
		Random random = new Random();
		char[] randomStr = new char[length];
		int len = chars.length;
		for (int i = 0; i < length; i++) {
			int index = random.nextInt(len);
			index = index % length;
			randomStr[i] = chars[index];
		}
		return String.valueOf(randomStr);

	}

	/**
	 * 生成MD5
	 * @param message
	 * @return
	 */
	public static String md5(String message, Object salt){
		try{
			MessageDigest messageDigest = MessageDigest.getInstance("MD5");
			if (salt != null && !"".equals(salt)) {
				message =  message + "{" + salt.toString() + "}";
			}
			byte[] digest = messageDigest.digest(message.getBytes("utf-8"));
			return Hex.encodeHexString(digest);
		}
		catch(NoSuchAlgorithmException | UnsupportedEncodingException ex){}
		
		return null;

	}
	
	/**
	 * Md5 加密
	 * 
	 * @param password
	 * @param salt
	 * @return
	 */
	public static String md5(String password) {
		return md5(password, null);
	}
	
	/**
	 * 判断字符串是否为空
	 * 
	 * @param string
	 * @return
	 */
	public static boolean isNullOrEmpty(String string) {
		return string == null || "".equals(string);
	}
	
	/**
	 * 数字字符串
	 * @param string
	 * @return
	 */
	public static boolean isNumeric(String string){
		return string.matches("\\d*");
	}
}
