package com.crawler.weixin.mini.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.redis.utils.RedisManager;
import com.crawler.social.config.SocialProperties;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.mini.vo.MiniLoginInfo;
import com.crawler.weixin.mini.vo.MiniSession;
import com.crawler.weixin.mini.vo.MiniUserInfo;

import net.sf.json.JSONObject;

/**
 * 微信
 * @author rubekid
 *
 * 2017年1月9日 下午4:03:31
 */
public class WxAppUtil {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(WxAppUtil.class);
	
	/**
	 * 小程序 appid
	 */
	public static final String APP_ID = SocialProperties.getProperty("wx.mini.app_id", SocialProperties.getProperty("mini.app_id"));
	
	/**
	 * 小程序 secret
	 */
	public static final String APP_SECRET = SocialProperties.getProperty("wx.mini.app_secret", SocialProperties.getProperty("mini.app_secret"));
	
	/**
	 * 获取session 
	 */
	public static final String SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
	
	public static final String SESSION_CACHE_KEY_PREFIX = "wx:session:";
	
	
	
	/**
	 * 获取session
	 * @param code
	 * @return
	 */
	public static MiniSession getSessionByCode(String code){
		return getSessionByCode(APP_ID, APP_SECRET, code);
	}
	
	/**
	 * 获取session
	 * @param code
	 * @return
	 */
	public static MiniSession getSessionByCode(String appId, String appSecret, String code){
		String url = String.format(SESSION_URL, appId, appSecret, code);
		MiniSession session =  SimpleHttpClient.getForObject(url, MiniSession.class);
		if(session != null){			
			create3rdSession(session);
		}
		return session;
	}
	
	/**
	 * 根据sessionId 获取session
	 * @param sessionId
	 * @return
	 */
	public static MiniSession getSessionById(String sessionId){
		String key = sessionKey(sessionId);
		return RedisManager.get(key, MiniSession.class);
	}
	
	
	/**
	 * 生成sessionID
	 * @param session
	 */
	public static void create3rdSession(MiniSession session){
		String sessionId = RandomStringUtils.randomAlphanumeric(64);
		if(session != null){
			session.setSessionId(sessionId);
			String key = sessionKey(sessionId);
			RedisManager.set(key, session, session.getExpiresIn());
		}
	}
	
	/**
	 * 获取微信用户信息
	 * @param loginInfo
	 * @param sessionKey
	 * @return
	 */
	public static MiniUserInfo getUserInfo(MiniLoginInfo loginInfo, String sessionKey){
		return getUserInfo(APP_ID, loginInfo, sessionKey);
	}
	
	/**
	 * 获取微信用户信息
	 * @param appId
	 * @param loginInfo
	 * @param sessionKey
	 * @return
	 */
	public static MiniUserInfo getUserInfo(String appId, MiniLoginInfo loginInfo, String sessionKey){
		try{
			AES aes = new AES();
	        byte[] resultByte = aes.decrypt(Base64.decodeBase64(loginInfo.getEncryptedData()),
	        		Base64.decodeBase64(sessionKey), Base64.decodeBase64(loginInfo.getIv()));
	        if(null != resultByte && resultByte.length > 0){
	            String userInfo = new String(resultByte, "UTF-8");
	            MiniUserInfo userInfoVo = (MiniUserInfo) JSONObject.toBean(JSONObject.fromObject(userInfo), MiniUserInfo.class);
	            if(userInfoVo.getWatermark().getAppid().equals(appId)){
	            	return userInfoVo;
	            }
	        }
		}
		catch(InvalidAlgorithmParameterException | UnsupportedEncodingException ex){
			LOGGER.error(ex.getMessage(), ex);
		}
		return null;
	}

	/**
	 * session 缓存key
	 * @param sessionId
	 * @return
	 */
	private static String sessionKey(String sessionId){
		return SESSION_CACHE_KEY_PREFIX + sessionId;
	}

}
