package com.crawler.weixin.mini.vo;

/**
 * 小程序session
 * @author rubekid
 *
 * 2017年10月14日 下午3:30:20
 */
public class MiniSession {
	
	/**
	 * session ID
	 */
	private String sessionId;
	
	/**
	 * 有效期
	 */
	private int expiresIn;
	
	/**
	 *  会话密钥
	 */
	private String sessionKey;

	/**
	 * 用户唯一标识	
	 */
	private String openid;
	
	/**
	 * 用户在开放平台的唯一标识符，在满足 UnionID 下发条件的情况下会返回
	 */
	private String unionid;
	
	/**
	 * 错误码
	 */
	private Integer errcode;
	
	/**
	 * 错误信息
	 */
	private String errmsg;

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public int getExpiresIn() {
		return expiresIn <=0 ? 7200 : expiresIn;
	}

	public void setExpiresIn(int expiresIn) {
		this.expiresIn = expiresIn;
	}

	public String getSessionKey() {
		return sessionKey;
	}

	public void setSessionKey(String sessionKey) {
		this.sessionKey = sessionKey;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getUnionid() {
		return unionid;
	}

	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}

	public Integer getErrcode() {
		return errcode;
	}

	public void setErrcode(Integer errcode) {
		this.errcode = errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

}
