package com.crawler.weixin.push;

import java.util.Map;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * 小程序消息模板
 * @author rubekid
 *
 * 2018年3月23日 下午1:43:43
 */
public class SubscribeTemplate {

	/**
	 * 用户OPENID
	 */
	private String touser;
	
	/**
	 * 模板ID
	 */
	@JSONField(name = "template_id")
	private String templateId;
	
	/**
	 * 小程序页面
	 */
	private String page;

	/**
	 * 数据
	 */
	private Map<String, SubscribeTemplateParam> data;
	
	/**
	 * 跳转小程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版
	 */
	@JSONField(name = "miniprogram_state")
	private String miniprogramState = "formal";
	
	
	/**
	 * 进入小程序查看”的语言类型，支持zh_CN(简体中文)、en_US(英文)、zh_HK(繁体中文)、zh_TW(繁体中文)，默认为zh_CN
	 */
	private String lang = "zh_CN";
	
	public String getTouser() {
		return touser;
	}

	public void setTouser(String touser) {
		this.touser = touser;
	}

	public String getTemplateId() {
		return templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getPage() {
		return page;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public Map<String, SubscribeTemplateParam> getData() {
		return data;
	}

	public void setData(Map<String, SubscribeTemplateParam> data) {
		this.data = data;
	}

	public String getMiniprogramState() {
		return miniprogramState;
	}

	public void setMiniprogramState(String miniprogramState) {
		this.miniprogramState = miniprogramState;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}

	
}
