/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Coords;
import com.crawler.beans.Location;
import com.crawler.utils.IpAddressUtils;
import com.crawler.utils.http.SimpleHttpClient;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiduMapUtils.class);
    private static final String GEO_CODER_URL = "http://api.map.baidu.com/geocoder/v2/?ak=XoZYVVPR337Ot2AOBfUqLEum&output=json&address=%s&city=%s";
    private static final String IP_URL = "http://api.map.baidu.com/location/ip?ak=XoZYVVPR337Ot2AOBfUqLEum&coor=bd09ll&ip=%s";
    private static final String COORDS_URL = "http://api.map.baidu.com/geocoder/v2/?location=%s,%s&output=json&ak=XoZYVVPR337Ot2AOBfUqLEum";

    public static Coords getCoords(String city, String address) {
        Coords coords = null;
        if (city != null) {
            if (city.indexOf("\u5e02") == -1) {
                city = String.valueOf(city) + "\u5e02";
            }
            if (address == null || "".equals(address)) {
                address = city;
            }
            try {
                String url = String.format(GEO_CODER_URL, address, city);
                JSONObject response = SimpleHttpClient.getForObject(url, JSONObject.class);
                if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                    JSONObject result = response.getJSONObject("result");
                    JSONObject location = result.getJSONObject("location");
                    coords = new Coords();
                    coords.setLongitude(location.getDouble("lng"));
                    coords.setLatitude(location.getDouble("lat"));
                }
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return coords;
    }

    public static Location getLocation(HttpServletRequest request) {
        String url = String.format(IP_URL, IpAddressUtils.getIpAddress(request));
        JSONObject response = SimpleHttpClient.getForObject(url, JSONObject.class);
        if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
            JSONObject content = response.getJSONObject("content");
            Location location = new Location();
            Coords coords = new Coords(content.getJSONObject("point").getDouble("x"), content.getJSONObject("point").getDouble("y"));
            JSONObject addressDetail = content.getJSONObject("address_detail");
            location.setProvince(addressDetail.getString("province"));
            location.setCity(addressDetail.getString("city"));
            location.setDistrict(addressDetail.getString("district"));
            location.setCoords(coords);
            return location;
        }
        return null;
    }

    public static Location getLocation(Coords coords) {
        String url = String.format(COORDS_URL, coords.getLatitude(), coords.getLongitude());
        JSONObject response = SimpleHttpClient.getForObject(url, JSONObject.class);
        if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
            JSONObject result = response.getJSONObject("result");
            Location location = new Location();
            location.setCoords(coords);
            JSONObject addressDetail = result.getJSONObject("addressComponent");
            location.setProvince(addressDetail.getString("province"));
            location.setCity(addressDetail.getString("city"));
            location.setDistrict(addressDetail.getString("district"));
            location.setStreet(addressDetail.getString("street"));
            return location;
        }
        return null;
    }
}

