package com.crawler.beans.properties;

import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 微信配置
 * @author Rubekid
 *
 * 2017年3月31日 下午8:41:29
 */
public class WechatProperties {

	private static final Logger logger = LoggerFactory.getLogger(WechatProperties.class);
    private static Properties properties;

    static {
        try {
            properties = new Properties();
            InputStream stream = WechatProperties.class.getClassLoader().getResourceAsStream("wechat.properties");
            if (stream != null) {
                properties.load(stream);
            }
        } catch (Exception ex) {
            logger.warn("Read wechat.properties error.", ex);
        }
    }
    
    /**
     * APP ID
     */
    public static final String APP_ID = properties.getProperty("app.id");
    
    /**
     * APP SECRET
     */
    public static final String APP_SECRET = properties.getProperty("app.secret");
    
    

}
