package com.crawler.excel;

/**
 * excel 块状区域
 * @author yanglizhe
 *
 */
public class ExcelBox {
	private int x1;
	
	private int y1;
	
	private int x2;
	
	private int y2;
	
	public ExcelBox(int width, int height, int colWidth, int rowHeight, int padding){
		double ratio = 1;
		int innerWidth = colWidth - 2 * padding;
		int innerHeight = rowHeight - 2 * padding; 
		if((double) width / height > (double) innerWidth/ innerHeight){
			if(width > innerWidth){
				ratio = (double) innerWidth / width;
			}
		}
		else{
			if(height > innerHeight){
				ratio = (double) innerHeight / height;
			}
		}
		
		int boxWidth = (int)(width * ratio);
		int boxHeight = (int)(height * ratio);
		x1 = (colWidth - boxWidth) / 2;
		y1 = (rowHeight - boxHeight) / 2;
		x2 = x1 + boxWidth;
		y2 = y1+ boxHeight;
	}

	public int getX1() {
		return x1;
	}

	public void setX1(int x1) {
		this.x1 = x1;
	}

	public int getY1() {
		return y1;
	}

	public void setY1(int y1) {
		this.y1 = y1;
	}

	public int getX2() {
		return x2;
	}

	public void setX2(int x2) {
		this.x2 = x2;
	}

	public int getY2() {
		return y2;
	}

	public void setY2(int y2) {
		this.y2 = y2;
	}
}
