package com.crawler.utils;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;

import com.crawler.common.config.UtilProperties;

/**
 * 自定义缓存服务
 * @author rubekid
 * @date 2016年11月11日
 * @param <T>
 * @param <PK>
 */
public abstract class EhCacheService<T, PK extends Serializable> {
	
    private final static String EHCACHE_NAME = UtilProperties.getProperty("ehcache.name");
	
	@Autowired
	protected EhCacheCacheManager cacheManager;

	protected Class<T> entityClass;
	
	protected String prefix;
	
	/**
	 * 通过子类的泛型定义取得对象类型Class.
	 */
	public EhCacheService(){		
		this.entityClass = ReflectionUtils.getSuperClassGenricType(getClass());
		prefix = entityClass.getName().toLowerCase() + ".";
	}
	
	/**
	 * 按id获取对象.
	 */
	public abstract T get(final PK id);
	
	/**
	 * 返回缓存
	 */
	public T getCache(final PK id){
		T t = (T) getCache(getKey(id), entityClass);
		if(t == null){
			t = get(id);
			setCahce(id, t);
		}
		return t;
	}
    
    /**
     * 设置缓存
     * @param key
     * @param value
     */
    public void setCahce(PK id, Object value) {
       setCahce(getKey(id), value);
    }
    
    /**
	 * 返回缓存
	 */
	public <T> T  getCache(String key, Class<T> clazz){
		Cache cache = cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get(key);
        if (value == null) {
            return null;
        }
        return (T) value.get();
	}
    
    /**
     * 设置缓存
     * @param key
     * @param value
     */
    public void setCahce(String key, Object value) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        if(value!=null){
            cache.put(key, value);
        }
    }

    
    /**
     * 缓存KEY
     * @param values
     * @return
     */
    public String getKey(PK id){
    	return prefix + id;
    }
}
