/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.ZipItem;
import com.crawler.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.springframework.web.multipart.MultipartFile;

public class ZipUtils {
    private static final String CHINESE_CHARSET = "GBK";
    private static final int CACHE_SIZE = 1024;

    public static File unzip(MultipartFile multipartFile, String basePath) throws IllegalStateException, IOException {
        String path = String.valueOf(basePath) + "/" + System.currentTimeMillis() + StringUtils.getRandomString(8);
        String fileName = String.valueOf(path) + ".zip";
        File file = new File(fileName);
        file.createNewFile();
        multipartFile.transferTo(file);
        File directory = new File(path);
        directory.mkdirs();
        ZipUtils.unzip(file.getAbsolutePath(), String.valueOf(path) + "/");
        file.delete();
        return directory;
    }

    public static void unzip(String zipFilePath, String path) {
        block16: {
            ZipFile zipFile = null;
            try {
                try {
                    BufferedInputStream bis = null;
                    FileOutputStream fos = null;
                    BufferedOutputStream bos = null;
                    zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
                    Enumeration zipEntries = zipFile.getEntries();
                    byte[] cache = new byte[1024];
                    while (zipEntries.hasMoreElements()) {
                        ZipEntry entry = (ZipEntry)zipEntries.nextElement();
                        if (entry.isDirectory()) {
                            new File(String.valueOf(path) + entry.getName()).mkdirs();
                            continue;
                        }
                        bis = new BufferedInputStream(zipFile.getInputStream(entry));
                        File file = new File(String.valueOf(path) + entry.getName());
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            parentFile.mkdirs();
                        }
                        fos = new FileOutputStream(file);
                        bos = new BufferedOutputStream(fos, 1024);
                        int readIndex = 0;
                        while ((readIndex = bis.read(cache, 0, 1024)) != -1) {
                            fos.write(cache, 0, readIndex);
                        }
                        bos.flush();
                        bos.close();
                        fos.close();
                        bis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zipFile == null) break block16;
                    try {
                        zipFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static ByteArrayOutputStream compress(String resourcesPath) throws Exception {
        File resourcesFile = new File(resourcesPath);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream((OutputStream)new BufferedOutputStream(byteArrayOutputStream));
        ZipUtils.createCompressedFile(out, resourcesFile, "");
        out.close();
        return byteArrayOutputStream;
    }

    public static void createCompressedFile(ZipOutputStream out, File file, String dir) throws Exception {
        if (dir == null) {
            dir = "";
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files.length > 0) {
                dir = "".equals(dir) ? "" : String.valueOf(dir) + "/";
                int i = 0;
                while (i < files.length) {
                    ZipUtils.createCompressedFile(out, files[i], String.valueOf(dir) + files[i].getName());
                    ++i;
                }
            } else if (!"".equals(dir)) {
                out.putNextEntry(new ZipEntry(String.valueOf(dir) + "/"));
            }
        } else {
            FileInputStream fis = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(dir));
            int count = 0;
            byte[] buffer = new byte[1024];
            while ((count = fis.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            fis.close();
        }
    }

    public static ByteArrayOutputStream createCompressedFile(List<ZipItem> zipItems) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream));
        for (ZipItem zipItem : zipItems) {
            if (zipItem.isFile()) {
                out.putNextEntry(new ZipEntry(zipItem.getPath()));
                int count = 0;
                byte[] buffer = new byte[1024];
                while ((count = zipItem.getInputStream().read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                }
                continue;
            }
            out.putNextEntry(new ZipEntry(String.valueOf(zipItem.getPath()) + "/"));
        }
        out.flush();
        out.close();
        return outputStream;
    }
}

