package com.crawler.beans;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 请求参数类
 * 
 */
public class QueryParameter {
	public static final String ASC = "asc";
	public static final String DESC = "desc";
	protected int pageNo = 1;
	protected int pageSize = 1;
	protected int offset = 0;
	protected String orderBy = "";
	protected boolean autoCount = true;
	protected Map<String, String> alias = new HashMap<String, String>();

	public int getPageSize() {
		return this.pageSize;
	}

	public void setPageSize(Integer pageSize) {
		if (pageSize == null || pageSize < 1) {
			pageSize = Page.PAGE_SIZE;
		}
		this.pageSize = pageSize;
	}

	@JsonIgnore
	public int getOffset() {
		return offset;
	}

	public void setOffset(int offset) {
		this.offset = offset;
	}

	@JsonIgnore
	public boolean isPageSizeSetted() {
		return (this.pageSize > -1);
	}

	public int getPageNo() {
		return this.pageNo;
	}

	public void setPageNo(Integer pageNo) {
		if(pageNo == null || pageNo < 1){
			pageNo = 1;
		}
	
		this.pageNo = pageNo;
	}

	@JsonIgnore
	public int getFirst() {
		int first = 0;
		if ((this.pageNo > 0 &&  this.pageSize > 0)){
			first = ((this.pageNo - 1) * this.pageSize);
		}
		if(offset !=0){
			first += offset;
		}
		return first;
	}

	@JsonIgnore
	public boolean isFirstSetted() {
		return ((this.pageNo > 0) && (this.pageSize > 0));
	}

	@JsonIgnore
	public String getOrderBy() {
		return this.orderBy;
	}
	
	@JsonIgnore
	public boolean isOrderBySetted() {
		return StringUtils.isNotBlank(this.orderBy);
	}

	public void setOrderBy(String orderBy) {
		if(orderBy != null && !"".equals(orderBy)){
			String[] orders = StringUtils.split(orderBy, ',');
			for (String orderStr : orders) {
				String[] arr = orderStr.split("\\s+");
				if (!StringUtils.equals(DESC, arr[1]) && !StringUtils.equals(ASC, arr[1]))
					throw new IllegalArgumentException("排序方向" + orderStr + "不是合法值");
			}
			this.orderBy = orderBy.trim();
		}
	}

	@JsonIgnore
	public boolean isAutoCount() {
		return this.autoCount;
	}

	public void setAutoCount(boolean autoCount) {
		this.autoCount = autoCount;
	}

	public void addAlias(String name, String alias) {
		this.alias.put(name, alias);
	}

	@JsonIgnore
	public boolean hasAlias() {
		return (!(this.alias.isEmpty()));
	}

	@JsonIgnore
	public Map<String, String> getAlias() {
		return this.alias;
	}
}