package com.crawler.utils;

import java.math.BigDecimal;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.crawler.common.config.UtilConstant;
import com.crawler.pay.alipay.config.AlipayConfig;

/**
 * 支付宝工具类
 * @author rubekid
 * @date 2016年9月8日
 */
public class AlipayUtils {
	
	/**
	 * 获取订单信息
	 * @param BaseUrl
	 * @param orderNo
	 * @param subject
	 * @param detail
	 * @param totalFee
	 * @return
	 */
	public static String getOrderInfo(String BaseUrl, String orderNo, String subject, String detail, BigDecimal totalFee) {
		
		// 签约合作者身份ID
		String orderInfo = "partner=" + "\"" + AlipayConfig.PARTNER + "\"";

		// 签约卖家支付宝账号
		orderInfo += "&seller_id=" + "\"" + AlipayConfig.SELLER_EMAIL + "\"";

		// 商户网站唯一订单号
		orderInfo += "&out_trade_no=" + "\"" + orderNo + "\"";

		// 商品名称
		orderInfo += "&subject=" + "\"" + subject + "\"";

		// 商品详情
		orderInfo += "&body=" + "\"" + detail + "\"";

		// 商品金额
		orderInfo += "&total_fee=" + "\"" +  totalFee  + "\"";

		// 服务器异步通知页面路径
		orderInfo += "&notify_url=" + "\"" + BaseUrl +  UtilConstant.NOTIFY_URL + "\"";

		// 服务接口名称， 固定值
		orderInfo += "&service=\"mobile.securitypay.pay\"";

		// 支付类型， 固定值
		orderInfo += "&payment_type=\"1\"";

		// 参数编码， 固定值
		orderInfo += "&_input_charset=\"utf-8\"";

		// 设置未付款交易的超时时间
		// 默认30分钟，一旦超时，该笔交易就会自动被关闭。
		// 取值范围：1m～15d。
		// m-分钟，h-小时，d-天，1c-当天（无论交易何时创建，都在0点关闭）。
		// 该参数数值不接受小数点，如1.5h，可转换为90m。
		orderInfo += "&it_b_pay=\"30m\"";

		// extern_token为经过快登授权获取到的alipay_open_id,带上此参数用户将使用授权的账户进行支付
		// orderInfo += "&extern_token=" + "\"" + extern_token + "\"";

		// 支付宝处理完请求后，当前页面跳转到商户指定页面的路径，可空
		orderInfo += "&return_url=\"m.alipay.com\"";

		return orderInfo;
	}
	
	/**
	 * 申请退款
	 * @param orderNo
	 * @param tradeNo
	 * @param amount 退款额度
	 * @return
	 * @throws AlipayApiException
	 */
	public static boolean refund(String orderNo, String tradeNo, BigDecimal amount, String reason) throws AlipayApiException{
		AlipayClient alipayClient =  new DefaultAlipayClient(UtilConstant.ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID, AlipayConfig.APP_PRIVATE_KEY, "JSON", AlipayConfig.CHAESET, AlipayConfig.APP_PUBLIC_KEY);
		AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
		request.setBizContent("{" +
		"    \"out_trade_no\":\""+ orderNo +"\"," +
		"    \"trade_no\":\""+ tradeNo +"\"," +
		"    \"refund_amount\":"+ amount +"," +
		"    \"refund_reason\":\""+ reason +"\"" +
		"  }");
		AlipayTradeRefundResponse response = alipayClient.execute(request);
		if(response.isSuccess()){
			return true;
		} else {
			return false;
		}
	}
}
