package com.crawler.utils;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import com.crawler.beans.Page;

/**
 * 复制工具
 * @author rubekid
 * @date 2016年10月29日
 */
public class CopyUtils {

	private static final Logger LOGGER = LoggerFactory.getLogger(CopyUtils.class);
	
	/**
	 * 数据转换
	 * @param page
	 * @param clazz
	 * @param ignoreProperties
	 * @return
	 */
	public static <T> Page<T> translate(Page<?> page, Class<T> clazz, String ... ignoreProperties) {
		Page<T> newPage = new Page<T>(page.getPageSize(), page.getPageNo());
		List<T> items = translate(page.getItems(), clazz, ignoreProperties);
		newPage.setTotalCount(page.getTotalCount());
		newPage.setItems(items);
		return newPage;
	
	}
	
	/**
	 * 数据转换
	 * @param list
	 * @param clazz
	 * @param ignoreProperties
	 * @return
	 */
	public static <T> List<T> translate(List<?> list, Class<T> clazz, String ... ignoreProperties ){
		List<T> items = new ArrayList<T>();
	
		for(int i=0; i< list.size(); i++){
			items.add(translate(list.get(i), clazz, ignoreProperties));
		}
	
		return items;	
	}
	
	public static <T> T translate(Object object, Class<T> clazz, String ... ignoreProperties){
		try {
			T item = clazz.newInstance();
			BeanUtils.copyProperties(object, item, ignoreProperties);
			return item;
		} catch (InstantiationException | IllegalAccessException ex) {
			LOGGER.error(ex.getMessage(), ex);
		}
		return null;
	}
}
