package com.crawler.utils;

import javax.servlet.http.HttpServletRequest;

import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;

import com.crawler.common.config.UtilProperties;

/**
 * 查看EhCacheManager
 * EhCache Utils
 * @author rubekid
 *
 */
@Deprecated
public class EhCacheUtils {

    private final static String EHCACHE_NAME = UtilProperties.getProperty("ehcache.name", "crawler-cache");
    
    private final static String NORMAL_KEY_PREFIX = "normal";

    /**
     * 获取缓存
     * @param request
     * @param cacheManager
     * @return
     */
    public static String getCacheValue(HttpServletRequest request, EhCacheCacheManager cacheManager) {
        String key = getKey(request);
        return getCacheValue(key, cacheManager);
    }
    
    /**
     * 获取缓存
     * @param key
     * @param cacheManager
     * @return
     */
    public static String getCacheValue(String key, EhCacheCacheManager cacheManager) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get(key);
        if (value == null) {
            return null;
        }
        return value.get().toString();
    }

    /**
     * 设置缓存
     * @param request
     * @param value
     * @param cacheManager
     */
    public static void putCacheValue(HttpServletRequest request, String value, EhCacheCacheManager cacheManager) {
        String key=getKey(request);
        putCacheValue(key, value, cacheManager);
    }
    
    /**
     * 设置缓存
     * @param key
     * @param value
     * @param cacheManager
     */
    public static void putCacheValue(String key, String value, EhCacheCacheManager cacheManager) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        if(!StringUtils.isNullOrEmpty(value)){
            cache.put(key, value);
        }
    }
    
    /**
     * 缓存KEY
     * @param values
     * @return
     */
    public static String getKey(String ... values){
    	StringBuffer stringBuffer = new StringBuffer();
    	stringBuffer.append(NORMAL_KEY_PREFIX);
    	for(String value : values){
    		stringBuffer.append("_");
    		stringBuffer.append(value);
    	}
    	return StringUtils.md5(stringBuffer.toString(), null);
    }

    /**
     * 缓存KEY
     * @param request
     * @return
     */
    private static String getKey(HttpServletRequest request){
        String url = request.getRequestURI();
        if (!StringUtils.isNullOrEmpty(request.getQueryString())) {
            url = url + "?" + request.getQueryString();
        }
        return StringUtils.md5(url, null);
    }
}
