package com.crawler.utils;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;

/**
 * 参数工具
 * @author rubekid
 * @date 2016年7月27日
 */
public class ParamsUtils {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(ParamsUtils.class);
	
	@SuppressWarnings("unchecked")
	public static final Map<String, Object> parse(String str){
		Map<String, Object> map = new HashMap<String, Object>();
		if(!StringUtils.isNullOrEmpty(str)){
			try{
				map = JSON.parseObject(str, new HashMap<String, Object>().getClass());
			}
			catch(Exception ex){
				LOGGER.error(ex.getMessage(), ex);
			}
		}
		
		return map;
	}

}
