package com.crawler.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.client.http.RestHttpClient;
import com.crawler.common.config.UtilProperties;
import com.crawler.rest.utils.Warner;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;

import net.sf.json.JSONObject;

/**
 * 七牛工具
 * @author rubekid
 *
 * 2016年12月31日 下午11:20:35
 */
public class QiNiuUtils {
	
	 private static final Logger logger = LoggerFactory.getLogger(UtilProperties.class);
	 private static Properties properties;

	static {
		try {
			properties = UtilProperties.getProperties();
			InputStream stream = QiNiuUtils.class.getClassLoader().getResourceAsStream("qiniu.properties");
	        if (stream != null) {
	            properties.load(stream);
	        }
	    } catch (Exception ex) {
	        logger.warn("Read config.properties error.", ex);
	    }
	}

	public static final String DOMAIN = properties.getProperty("qiniu.domain");
	private static final String ACCESS_KEY = properties.getProperty("qiniu.access_key");
	private static final String SECRET_KEY = properties.getProperty("qiniu.secret_key");
	private static final String BUCKET_NAME = properties.getProperty("qiniu.bucket");

	private static final Auth auth = Auth.create(ACCESS_KEY, SECRET_KEY);

	/**
	 * 简单上传，使用默认策略，只需要设置上传的空间名就可以了
	 * @return
	 */
	public static String getUpToken() {
		return auth.uploadToken(BUCKET_NAME, null, 3600 * 100, null, true);
	}
	
	/**
	 * 根据空间名获取
	 * @param buketName
	 * @return
	 */
	public static String getUpToken(String buketName){
		return auth.uploadToken(buketName, null, 3600 * 100, null, true);
	}

	/**
	 * 
	 * @param filePath "/.../...";
	 * @param fileName 上传到七牛后保存的文件名
	 * @throws IOException
	 */
	public static void upload(byte[] data, String fileName) throws IOException {
		try {

			// 创建上传对象
			UploadManager uploadManager = new UploadManager();

			// 调用put方法上传
			Response res = uploadManager.put(data, fileName, getUpToken());
			// 打印返回的信息
			System.out.println(res.bodyString());
		} catch (QiniuException e) {
			Response r = e.response;
			// 请求失败时打印的异常的信息
			System.out.println(r.toString());
			try {
				// 响应的文本信息
				Warner.send(r.bodyString());
			} catch (QiniuException e1) {
				// ignore
			}
			throw new RuntimeException("上传失败");
		}
	}
	
	/**
	 * 根据地址获取图片信息
	 * @param url
	 * @return
	 */
	public static JSONObject imageInfo(String url){
		RestHttpClient client = new RestHttpClient();
		JSONObject json = client.getForObject(url + "?imageInfo", JSONObject.class);
		return json;
	}
	
	/**
	 * 网络图片迁移
	 * @param url
	 * @param findName
	 * @throws IOException 
	 */
	public static String transfer(String url, String fileName) throws IOException{
		if(fileName == null){
			fileName = StringUtils.uniqueId() + url.substring(url.lastIndexOf("."));
		}
		byte[] types = toByte(url);
		if(types == null){
			return null;
		}
		QiNiuUtils.upload(types, fileName);
		return QiNiuUtils.DOMAIN + "/" + fileName;
	}
	
	/**
	 * 图片迁移
	 * @param url
	 * @return
	 * @throws IOException 
	 */
	public static String transfer(String url) throws IOException{
		return transfer(url, null);
	}
	
	/**
	 * 网络资源转byte[]
	 * @param urlString 网络地址
	 * @return
	 * @throws IOException
	 */
	private static byte[] toByte(String urlString){
		try{
			URL url = new URL(urlString);  
	        URLConnection con = url.openConnection();
	        con.setConnectTimeout(5*1000);  
	        InputStream is = con.getInputStream();
	        ByteArrayOutputStream output = new ByteArrayOutputStream();
	        byte[] buffer = new byte[4096];
	        int n = 0;
	        while (-1 != (n = is.read(buffer))) {
	            output.write(buffer, 0, n);
	        }
	        is.close();  
	        return output.toByteArray();
		}
        catch (IOException ex) {
			logger.error(ex.getMessage(), ex);
		}
		return null;
	}

	
	
	
	
}
