package com.crawler.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.crawler.beans.Node;
import com.crawler.beans.TreeNode;

/**
 * 树工具类
 * @author Rubekid
 *
 * 2017年5月23日 下午4:28:14
 */
public class TreeNodeUtils {

	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<TreeNode> generateTree(List<Node> nodes, String rootId){
		Map<String, List<TreeNode>> map = new HashMap<String, List<TreeNode>>();
		for(Node node : nodes){
			String parentId = node.getParentId();
			List<TreeNode> treeNodes = new ArrayList<TreeNode>();
			if(map.containsKey(parentId)){
				treeNodes = map.get(parentId);
			}
			TreeNode treeNode = new TreeNode();
			treeNode.setId(node.getId());
			treeNode.setName(node.getName());
			treeNode.setImage(node.getImage());
			treeNodes.add(treeNode);
			map.put(parentId, treeNodes);
		}
		
		return buildNode(map, rootId);
		
	}
	
	/**
	 * 组装节点
	 * @param map
	 * @param parentId
	 * @return
	 */
	public static List<TreeNode> buildNode(Map<String, List<TreeNode>> map, String parentId){
		List<TreeNode> nodes = map.get(parentId);
		if(nodes!=null){
			for(TreeNode treeNode : nodes){
				treeNode.setChildren(buildNode(map, treeNode.getId()));
			}
		}
		return nodes;
		
	}
	
	
}
