/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.excel;

import com.crawler.excel.ExcelBean;
import com.crawler.excel.ExcelBox;
import com.crawler.excel.ExcelImage;
import com.crawler.excel.ExcelTitle;
import com.crawler.exception.ExcelException;
import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtil.class);

    public static <T> List<T> parse(MultipartFile multipartFile, Class<T> clazz, Map<String, String> keyConfig) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JSONArray array = ExcelUtil.parse(multipartFile);
            JSONArray labels = array.getJSONArray(0);
            for (int i = 1; i < array.size(); ++i) {
                JSONArray data = array.getJSONArray(i);
                JSONObject item = new JSONObject();
                for (int j = 0; j < data.size(); ++j) {
                    String label = labels.getString(j);
                    if (!keyConfig.containsKey(label)) continue;
                    String key = keyConfig.get(label);
                    item.put((Object)key, (Object)data.getString(j));
                }
                list.add(JSONObject.toBean((JSONObject)item, clazz));
            }
        }
        catch (IOException | IllegalStateException | InvalidFormatException e) {
            throw new ExcelException("Excel\u89e3\u6790\u5931\u8d25");
        }
        return list;
    }

    public static JSONArray parse(MultipartFile multipartFile) throws FileNotFoundException, IOException, InvalidFormatException {
        String name = multipartFile.getOriginalFilename();
        String ext = name.substring(name.lastIndexOf(".") + 1);
        if ("xls".equalsIgnoreCase(ext)) {
            return ExcelUtil.parseXLS(multipartFile.getInputStream());
        }
        if ("xlsx".equalsIgnoreCase(ext)) {
            return ExcelUtil.parseXLSX(multipartFile.getInputStream());
        }
        throw new ExcelException("\u4e0d\u662f\u6709\u6548\u7684excel\u6587\u4ef6");
    }

    public static JSONArray parse(File file) throws InvalidFormatException, IOException {
        String name = file.getName();
        String ext = name.substring(name.lastIndexOf(".") + 1);
        if ("xls".equalsIgnoreCase(ext)) {
            return ExcelUtil.parseXLS(file);
        }
        if ("xlsx".equalsIgnoreCase(ext)) {
            return ExcelUtil.parseXLSX(file);
        }
        throw new ExcelException("\u4e0d\u662f\u6709\u6548\u7684excel\u6587\u4ef6");
    }

    public static JSONArray parseXLS(File file) throws FileNotFoundException, IOException {
        return ExcelUtil.parseXLS(new FileInputStream(file));
    }

    public static JSONArray parseXLSX(File file) throws InvalidFormatException, IOException {
        return ExcelUtil.parseXLSX(new FileInputStream(file));
    }

    public static JSONArray parseXLS(InputStream inputStream) throws FileNotFoundException, IOException {
        JSONArray array = new JSONArray();
        POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
        HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(0);
        int rowstart = hssfSheet.getFirstRowNum();
        int rowEnd = hssfSheet.getLastRowNum();
        for (int i = rowstart; i <= rowEnd; ++i) {
            HSSFRow row = hssfSheet.getRow(i);
            if (null == row) continue;
            int cellStart = row.getFirstCellNum();
            short cellEnd = row.getLastCellNum();
            JSONArray jsonRow = new JSONArray();
            for (int k = cellStart; k <= cellEnd; ++k) {
                HSSFCell cell = row.getCell(k);
                if (null == cell) continue;
                jsonRow.add(ExcelUtil.getValue((Cell)cell));
            }
            array.add((Object)jsonRow);
        }
        hssfWorkbook.close();
        return array;
    }

    public static JSONArray parseXLSX(InputStream inputStream) throws InvalidFormatException, IOException {
        JSONArray array = new JSONArray();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
        XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
        int rowstart = xssfSheet.getFirstRowNum();
        int rowEnd = xssfSheet.getLastRowNum();
        for (int i = rowstart; i <= rowEnd; ++i) {
            XSSFRow row = xssfSheet.getRow(i);
            if (null == row) continue;
            int cellStart = row.getFirstCellNum();
            short cellEnd = row.getLastCellNum();
            JSONArray jsonRow = new JSONArray();
            for (int k = cellStart; k <= cellEnd; ++k) {
                XSSFCell cell = row.getCell(k);
                if (null == cell) continue;
                jsonRow.add(ExcelUtil.getValue((Cell)cell));
            }
            array.add((Object)jsonRow);
        }
        xssfWorkbook.close();
        return array;
    }

    public static void export(ExcelBean excelBean, HttpServletResponse response) {
        try {
            String filename = excelBean.getName();
            filename = new String(filename.replaceAll("\\s|;", "").getBytes("gbk"), "ISO8859-1");
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelUtil.createExcel(excelBean, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new RestSimpleException("\u5bfc\u51faexcel\u5931\u8d25");
        }
    }

    public static void createExcel(ExcelBean excelBean, OutputStream outputStream) throws IOException {
        HSSFCell cell;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(excelBean.getSheetName());
        HSSFRow row = sheet.createRow(0);
        HSSFFont titleFont = wb.createFont();
        titleFont.setColor((short)17);
        titleFont.setBoldweight((short)700);
        titleFont.setFontHeight(ExcelUtil.getRowHeight(14));
        HSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setFont(titleFont);
        ExcelUtil.setTitleStyle(wb, titleStyle);
        ExcelUtil.addBorder(titleStyle);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        ExcelUtil.setAlignCenter(cellStyle);
        ExcelUtil.setVerticalCenter(cellStyle);
        cellStyle.setWrapText(true);
        HSSFFont font = wb.createFont();
        font.setFontHeight(ExcelUtil.getRowHeight(14));
        cellStyle.setFont(font);
        ExcelTitle[] titles = excelBean.getTitles();
        for (int i = 0; i < titles.length; ++i) {
            ExcelTitle title = titles[i];
            cell = row.createCell(i);
            cell.setCellValue(title.getValue());
            cell.setCellStyle(titleStyle);
            int columnWidth = title.getWidth() > 0 ? title.getWidth() : excelBean.getColumnWidth();
            sheet.setColumnWidth(i, ExcelUtil.getColWidth(columnWidth));
        }
        int rowIndex = 1;
        int rowHeight = excelBean.getRowHeight();
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        for (String[] data : excelBean.getDataList()) {
            row = sheet.createRow(rowIndex++);
            if (rowHeight > 0) {
                row.setHeight(ExcelUtil.getRowHeight(rowHeight));
            } else {
                rowHeight = 18;
            }
            for (int j = 0; j < data.length; ++j) {
                String value = data[j];
                if (value == null || "null".equalsIgnoreCase(value)) {
                    value = "";
                }
                cell = row.createCell(j);
                if (ExcelUtil.isUrl(value)) {
                    if (ExcelUtil.isImage(value)) {
                        int columnWidth = titles[j].getWidth() > 0 ? titles[j].getWidth() : excelBean.getColumnWidth();
                        ExcelUtil.insertImage(wb, patriarch, value, rowHeight, columnWidth, (short)j, rowIndex);
                        continue;
                    }
                    ExcelUtil.setLink(wb, cell, value);
                    continue;
                }
                cell.setCellValue(value);
                cellStyle.setVerticalAlignment((short)1);
                cell.setCellStyle(cellStyle);
            }
        }
        wb.write(outputStream);
        wb.close();
    }

    public static void setLink(HSSFWorkbook wb, HSSFCell cell, String value) {
        cell.setCellValue(value);
        cell.setCellFormula("HYPERLINK(\"" + value + "\",\"" + value + "\")");
        HSSFCellStyle linkStyle = wb.createCellStyle();
        HSSFFont cellFont = wb.createFont();
        cellFont.setUnderline((byte)1);
        cellFont.setColor((short)12);
        linkStyle.setFont(cellFont);
        linkStyle.setVerticalAlignment((short)1);
        cell.setCellStyle(linkStyle);
    }

    public static void insertImage(HSSFWorkbook wb, HSSFPatriarch patriarch, String value, int rowHeight, int columnWidth, short col, int rowIndex) throws IOException {
        ExcelImage excelImage = new ExcelImage(value);
        ExcelBox excelBox = new ExcelBox(excelImage.getWidth(), excelImage.getHeight(), rowHeight, columnWidth, 10);
        HSSFClientAnchor anchor = new HSSFClientAnchor();
        int cw = ExcelUtil.getColWidth(columnWidth);
        short rh = ExcelUtil.getRowHeight(rowHeight);
        int rowNum = rowIndex - 1;
        anchor.setDx1(ExcelUtil.getAnchorX(excelBox.getX1(), cw));
        anchor.setDy1(ExcelUtil.getAnchorY(excelBox.getY1(), rh));
        anchor.setDx2(ExcelUtil.getAnchorX(excelBox.getX2(), cw));
        anchor.setDy2(ExcelUtil.getAnchorY(excelBox.getY2(), rh));
        anchor.setCol1(col);
        anchor.setRow1(rowNum);
        anchor.setCol2(col);
        anchor.setRow2(rowNum);
        anchor.setAnchorType(0);
        patriarch.createPicture(anchor, wb.addPicture(excelImage.getByteArray(), 5));
    }

    public static void setTitleStyle(HSSFWorkbook workbook, HSSFCellStyle style) {
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillPattern((short)1);
        HSSFPalette palette = workbook.getCustomPalette();
        palette.setColorAtIndex((short)42, (byte)-30, (byte)-17, (byte)-38);
        style.setFillForegroundColor((short)42);
    }

    public static void addBorder(HSSFCellStyle style) {
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
    }

    public static void setAlignCenter(HSSFCellStyle style) {
        style.setAlignment((short)2);
    }

    public static void setAlignLeft(HSSFCellStyle style) {
        style.setAlignment((short)1);
    }

    public static void setAlignRight(HSSFCellStyle style) {
        style.setAlignment((short)3);
    }

    public static void setVerticalCenter(HSSFCellStyle style) {
        style.setVerticalAlignment((short)1);
    }

    public static void setVerticalTop(HSSFCellStyle style) {
        style.setVerticalAlignment((short)0);
    }

    public static void setVerticalBottom(HSSFCellStyle style) {
        style.setVerticalAlignment((short)2);
    }

    public static int getAnchorX(int px, int colWidth) {
        return (int)Math.round(37262.458471760794 * (1.0 / (double)colWidth) * (double)px);
    }

    public static int getAnchorY(int px, int rowHeight) {
        return (int)Math.round(3827.2425249169437 * (1.0 / (double)rowHeight) * (double)px);
    }

    public static short getRowHeight(int px) {
        return (short)Math.round(14.933333333333334 * (double)px);
    }

    public static int getColWidth(int px) {
        return (int)Math.round(36.57 * (double)px);
    }

    public static boolean isUrl(String string) {
        Pattern pattern = Pattern.compile("^((http|https):\\/\\/([\\w\\-]+\\.)+[\\w\\-]+(\\/[\\w\\u4e00-\\u9fa5\\-\\.\\/?\\@\\%\\!\\&=\\+\\~\\:\\#\\;\\,]*)?)", 2);
        return pattern.matcher(string).matches();
    }

    public static boolean isImage(String string) {
        Pattern pattern = Pattern.compile("\\S+\\.(jpg|jpeg|png|gif|bmp)(\\?\\S+)?$", 2);
        return ExcelUtil.isUrl(string) && pattern.matcher(string).matches();
    }

    private static Object getValue(Cell cell) {
        Object value;
        switch (cell.getCellType()) {
            case 0: {
                try {
                    value = new DecimalFormat("#").format(cell.getNumericCellValue());
                }
                catch (ExcelException ex) {
                    value = cell.getNumericCellValue();
                }
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                break;
            }
            case 2: {
                value = cell.getCellFormula();
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }
}

