/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Coords;

public class CoordsUtils {
    static double FACTOR = 6378245.0;
    static double EE = 0.006693421622965943;
    public static final double EXPI = 52.35987755982988;
    public static final double LONGITUDE_RATE = 102834.74258026089;
    public static final double LATITUDE_RATE = 111712.69150641056;

    public static long distance(Coords coords1, Coords coords2) {
        if (coords1 == null || coords2 == null) {
            return 0L;
        }
        return CoordsUtils.distance(coords1.getLongitude(), coords1.getLatitude(), coords2.getLongitude(), coords2.getLatitude());
    }

    public static long distance(double lon1, double lat1, double lon2, double lat2) {
        double b = Math.abs((lon1 - lon2) * 102834.74258026089);
        double a = Math.abs((lat1 - lat2) * 111712.69150641056);
        return (long)Math.ceil(Math.sqrt(a * a + b * b));
    }

    public static double[] wgs2bd(double lat, double lon) {
        double[] wgs2gcj = CoordsUtils.wgs2gcj(lat, lon);
        double[] gcj2bd = CoordsUtils.gcj2bd(wgs2gcj[0], wgs2gcj[1]);
        return gcj2bd;
    }

    public static double[] gcj2bd(double lat, double lon) {
        double x = lon;
        double y = lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * 52.35987755982988);
        double bd_lon = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[]{bd_lat, bd_lon};
    }

    public static double[] bd2gcj(double lat, double lon) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gg_lon = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[]{gg_lat, gg_lon};
    }

    public static double[] wgs2gcj(double lat, double lon) {
        double dLat = CoordsUtils.transformLat(lon - 105.0, lat - 35.0);
        double dLon = CoordsUtils.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (FACTOR * (1.0 - EE) / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (FACTOR / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        double[] loc = new double[]{mgLat, mgLon};
        return loc;
    }

    private static double transformLat(double lat, double lon) {
        double ret = -100.0 + 2.0 * lat + 3.0 * lon + 0.2 * lon * lon + 0.1 * lat * lon + 0.2 * Math.sqrt(Math.abs(lat));
        ret += (20.0 * Math.sin(6.0 * lat * Math.PI) + 20.0 * Math.sin(2.0 * lat * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lon * Math.PI) + 40.0 * Math.sin(lon / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lon / 12.0 * Math.PI) + 320.0 * Math.sin(lon * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double lat, double lon) {
        double ret = 300.0 + lat + 2.0 * lon + 0.1 * lat * lat + 0.1 * lat * lon + 0.1 * Math.sqrt(Math.abs(lat));
        ret += (20.0 * Math.sin(6.0 * lat * Math.PI) + 20.0 * Math.sin(2.0 * lat * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lat / 12.0 * Math.PI) + 300.0 * Math.sin(lat / 30.0 * Math.PI)) * 2.0 / 3.0;
    }
}

