/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.crawler.utils.DateUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.security.crypto.codec.Base64;

public class StringUtils {
    private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String getRandomString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(random.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    public static String getRandomNumString(int length) {
        if (length <= 0) {
            return "";
        }
        char[] numbersAndLetters = "0123456789".toCharArray();
        Random random = new Random();
        char[] randomStr = new char[length];
        for (int i = 0; i < length; ++i) {
            randomStr[i] = numbersAndLetters[random.nextInt(numbersAndLetters.length)];
        }
        return String.valueOf(randomStr);
    }

    public static String md5(String password, Object salt) {
        Md5PasswordEncoder encoder = new Md5PasswordEncoder();
        return encoder.encodePassword(password, salt);
    }

    public static String md5(String password) {
        return StringUtils.md5(password, null);
    }

    public static String shortMd5(String password) {
        String md5 = StringUtils.md5(password);
        return md5.substring(8, 24);
    }

    public static String generateSalt() {
        return StringUtils.getRandomString(8);
    }

    public static String passwordMd5(String password, Object salt) {
        return StringUtils.md5(StringUtils.md5(password, salt), salt);
    }

    public static String SHA1(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(text.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || "".equals(string);
    }

    public static String groupString(String groups) {
        if (groups == null) {
            return "";
        }
        return "," + groups.replaceAll("^,|,$", "") + ",";
    }

    public static String firstNotNull(String ... strings) {
        for (String string : strings) {
            if (StringUtils.isNullOrEmpty(string)) continue;
            return string;
        }
        return "";
    }

    public static String getInitial(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return "#";
        }
        String initial = string.substring(0, 1).toUpperCase();
        if (!initial.matches("[A-Z]")) {
            initial = "#";
        }
        return initial;
    }

    public static String getBaseFileName(String path) {
        int pos = path.lastIndexOf("/");
        if (pos > -1) {
            path = path.substring(pos + 1);
        }
        if ((pos = path.lastIndexOf(".")) > -1) {
            path = path.substring(0, pos);
        }
        return path;
    }

    public static String base64(String str) {
        new Base64();
        byte[] bytes = Base64.encode((byte[])str.getBytes());
        return new String(bytes);
    }

    public static String TextDecode(String str) {
        if (str != null && !Charset.forName("GBK").newEncoder().canEncode(str)) {
            try {
                str = new String(str.getBytes("ISO-8859-1"), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static String UrlDecode(String str) {
        return StringUtils.TextDecode(str);
    }

    public static String decodeFun(String data) throws UnsupportedEncodingException {
        return new String(Base64.decode((byte[])data.getBytes()), "UTF-8");
    }

    public static String encodeFun(byte[] data) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])data), "UTF-8");
    }

    public static String secretDecode(String str) {
        try {
            str = URLDecoder.decode(StringUtils.decodeFun(URLDecoder.decode(str, "UTF-8")), "UTF-8");
            char[] result = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                int ascII = str.charAt(i);
                if (ascII < 12) {
                    ascII += 128;
                }
                result[i] = (char)(ascII - 12);
            }
            return String.valueOf(result);
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String secretEncode(String str) {
        try {
            char[] result = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                int ascII = str.charAt(i);
                if (ascII > 116) {
                    ascII -= 128;
                }
                result[i] = (char)(ascII + 12);
            }
            str = String.valueOf(result);
            return URLEncoder.encode(StringUtils.encodeFun(URLEncoder.encode(str, "UTF-8").getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String getDistanceText(long distance) {
        if (distance < 20L) {
            return "20m\u4ee5\u5185";
        }
        if (distance < 1000L) {
            return distance + "m";
        }
        return (double)Math.round((double)distance / 100.0) / 10.0 + "km";
    }

    public static String getGenderText(int gender) {
        if (gender == 1) {
            return "\u7537";
        }
        return "\u5973";
    }

    public static String substr(String text, int len) {
        if (text.length() > len) {
            text = text.substring(0, len - 2) + "...";
        }
        return text;
    }

    public static String formatNumber(Number number, Integer length, String prefix) {
        if (number == null) {
            return "";
        }
        long no = number.longValue();
        int len = length == null ? 3 : length;
        double max = Math.pow(10.0, len);
        String result = String.valueOf(no);
        if ((double)no < max) {
            no = (long)(max + (double)no);
            result = String.valueOf(no);
            result = result.substring(result.length() - len);
        }
        if (prefix != null) {
            result = prefix + result;
        }
        return result;
    }

    public static String formatNumber(Number number, Integer length) {
        return StringUtils.formatNumber(number, length, null);
    }

    public static boolean isNumeric(String string) {
        return string.matches("\\d*");
    }

    public static final <E> String[] toStrings(List<E> list) {
        String[] items = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            items[i] = JSONObject.toJSONString(list.get(i));
        }
        return items;
    }

    public static final String join(List<String> list, String separator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String str : list) {
            stringBuffer.append(str);
            stringBuffer.append(separator);
        }
        String result = stringBuffer.toString();
        if (!"".equals(separator)) {
            result = result.replaceAll(separator + "$", "");
        }
        return result;
    }

    public static final Object toObject(String value, String type) {
        if ("int".equalsIgnoreCase(type)) {
            return Integer.valueOf(value);
        }
        if ("long".equalsIgnoreCase(type)) {
            return Long.valueOf(value);
        }
        if ("float".equalsIgnoreCase(type)) {
            return Float.valueOf(value);
        }
        if ("double".equalsIgnoreCase(type)) {
            return Double.valueOf(value);
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return Boolean.valueOf(value);
        }
        if ("json".equalsIgnoreCase(type)) {
            return JSONObject.parse((String)value);
        }
        if ("array".equalsIgnoreCase(type)) {
            return JSONArray.parse((String)value);
        }
        if ("decimal".equalsIgnoreCase(value)) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static final List<String> split(String str, String regex) {
        if (StringUtils.isNullOrEmpty(str)) {
            return new ArrayList<String>();
        }
        String[] array = str.split(regex);
        return Arrays.asList(array);
    }

    public static final List<Integer> split2Ingeter(String str, String regex) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        if (!StringUtils.isNullOrEmpty(str)) {
            String[] array;
            for (String string : array = str.split(regex)) {
                items.add(Integer.valueOf(string));
            }
        }
        return items;
    }

    public static String uniqueNo(String prev) {
        return prev + DateUtils.getLongDate() + StringUtils.getRandomNumString(3);
    }

    public static String uniqueId() {
        return StringUtils.uniqueNo("");
    }
}

