package com.crawler.beans;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

import net.sf.json.JSONObject;


/**
 * 分页类
 * @author rubekid
 *
 * @param <T>
 */
public class Page<T> extends QueryParameter {
	
	public static final int PAGE_SIZE = 10;
	private List<T> items = new ArrayList<T>();
	private long totalCount = 0;
	private JSONObject queryParams = new JSONObject();

	public Page() {
		setPageSize(PAGE_SIZE);
	}
	
	public Page(Integer pageSize, Integer pageNo){
		setPageSize(pageSize);
		setPageNo(pageNo);
	}

	public List<T> getItems() {
		return items;
	}


	public void setItems(List<T> items) {
		this.items = items;
	}

	public long getTotalCount() {
		return this.totalCount;
	}

	public void setTotalCount(long totalCount) {
		this.totalCount = totalCount;
	}

	public long getTotalPages() {
		long count = totalCount / pageSize;
		if (totalCount % pageSize > 0){
			count ++;
		}
		return count;
	}

	@JsonIgnore
	public boolean isHasNext() {
		return (pageNo + 1 <= getTotalPages());
	}

	@JsonIgnore
	public int getNextPage() {
		if (isHasNext()){
			return pageNo + 1;
		}
		return this.pageNo;
	}

	@JsonIgnore
	public boolean isHasPre() {
		return (pageNo - 1 >= 1);
	}

	@JsonIgnore
	public int getPrePage() {
		if (isHasPre()){
			return pageNo - 1;
		}
		return pageNo;
	}

	public void addQueryParam(String key, Object value) {
		queryParams.put(key, value);
	}

	@SuppressWarnings("unchecked")
	@JsonIgnore
	public String getQueryString() throws UnsupportedEncodingException{
		String result = "";
		for (Iterator<String> iterator = queryParams.keys(); iterator.hasNext();) {
			String key = iterator.next();
			result += key + "=" + URLEncoder.encode(queryParams.getString(key), "utf-8") + "&";
		}
		
		if (result.length() > 0){
			result = result.substring(0, result.length() - 1);
		}
		return result;
	}

	@JsonIgnore
	public String getQueryParamString() {
		return queryParams.toString();
	}

	public void setQueryString(String queryString) {
		queryParams = JSONObject.fromObject(queryString);
	}

	@JsonIgnore
	public JSONObject getQueryParams() {
		return queryParams;
	}
}