package com.crawler.common.config;

import com.crawler.rest.config.WafProperties;

/**
 * 工具常量
 * @author rubekid
 * @date 2016年11月3日
 */
public class UtilConstant {
	
	/**
	 * 网址
	 */
	public static final String BASE_URL = WafProperties.getProperty("site.url");

	
	/**
	 * 上传路径
	 */
	public static final String UPLOAD_PATH = WafProperties.getProperty("upload.path", "/upload");
	
	/**
	 * 支付宝异步通知
	 */
	public static final String NOTIFY_URL = UtilProperties.getProperty("notify.url", "/app/alipay/notify_url");
	
	/**
	 * 微信异步通知
	 */
	public static final String WXNOTIFY_URL = UtilProperties.getProperty("wxnotify.url", "/app/wxpay/notify_url");
	
	/**
	 * 微信常量设置
	 */
	public static final String WX_APP_ID =  UtilProperties.getProperty("wx.app_id");
	public static final String WX_MCH_ID = UtilProperties.getProperty("wx.mch_id");
	public static final String WX_CERT_PATH = UtilProperties.getProperty("wx.cert_path", "cert");
	public static final String WX_APP_KEY = UtilProperties.getProperty("wx.app_key");
	public static final String WX_APP_SECRET = UtilProperties.getProperty("wx.app_secret");
	public static final String WX_UNIFIED_ORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
	public static final String WX_ORDER_QUERY = "https://api.mch.weixin.qq.com/pay/orderquery";
	public static final String WX_REFUND = "https://api.mch.weixin.qq.com/secapi/pay/refund";
	
	/**
	 * 微信公众号ID
	 */
	public static final String WECHAT_APPID = WafProperties.getProperty("wechat.app.id");
	
	/**
	 * 微信公众号Secret
	 */
	public static final String WECHAT_APPSECRET = WafProperties.getProperty("wechat.app.secret");
	
	/**
	 * 支付宝订单查询接口
	 */
	public static final String ALIPAY_TRADE_QUERY = "https://openapi.alipay.com/gateway.do";
	


}
