package com.crawler.utils;

import javax.servlet.http.HttpServletRequest;

import com.crawler.beans.Coords;

/**
 * 坐标管理器
 * @author rubekid
 * @date 2016年11月6日
 */
public class CoordsManager {
	
	/**
	 * 获取定位
	 * @param request
	 * @return
	 */
	public static Coords getCoords(HttpServletRequest request){
		String lng = request.getParameter("longitude");
		String lat = request.getParameter("latitude");
		if(lng!=null && lat !=null){
			Double longitude = Double.valueOf(lng);
			Double latitude = Double.valueOf(lat);
			if(longitude!=null && longitude > 0 && latitude != null && latitude > 0){
				return new Coords(longitude, latitude);
			}
		}
		return null;
	}
	
	
	/**
	 * 获取定位
	 * @param longitude
	 * @param latitude
	 * @return
	 */
	public static Coords getCoords(Double longitude, Double latitude){
		if(longitude!=null && longitude > 0 && latitude != null && latitude > 0){
			return new Coords(longitude, latitude);
		}
		return null;
	}

}