package com.crawler.utils;

import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;

/**
 * 参数校验器
 * @author rubekid
 * 2016年12月1日
 */
public class ParamenterChecker {

	/**
	 * 不能为Null
	 * @param object
	 * @param message
	 */
	public static void notNull(Object object, String message){
		if(object == null){
			throw new RestSimpleException(message);
		}
	}
	
	/**
	 * 不能为空
	 * @param string
	 * @param message
	 */
	public static void notEmptyOrNull(String string, String message){
		if(isEmptyOrNull(string)){
			throw new RestSimpleException(message);
		}
	}
	
	/**
	 * 是否为空
	 * @param string
	 */
	public static boolean isEmptyOrNull(String string){
		if(string == null || "".equals(string.trim())){
			return true;
		}
		return false;
	}
	
	
	/**
	 * 不能为空
	 * @param number
	 * @param message
	 */
	public static void notEmptyOrZero(Number number, String message){
		if(isEmptyOrZero(number)){
			throw new RestSimpleException(message);
		}
	}
	
	/**
	 * 判断是否为空或0
	 * @param number
	 * @param message
	 * @return
	 */
	public static boolean isEmptyOrZero(Number number){
		if(number == null || number.doubleValue() == 0D){
			return true;
		}
		return false;
	}
	
}
