package com.crawler.utils;

import javax.servlet.http.HttpServletRequest;

import com.crawler.common.config.UtilConstant;
import com.crawler.component.SpringContextUtil;

/**
 * web工具类
 * @author rubekid
 * @date 2016年9月8日
 */
public class WebUtils {
	
	/**
	 * 获取当前服务器根目录
	 * @return
	 */
	public static String getContextPath() {
		return SpringContextUtil.getServletContext().getRealPath("/");
	}
	
	
	public static String getUploadPath(){
		return getContextPath() + UtilConstant.UPLOAD_PATH;
	}
	

	/**
	 * 获取基础地址
	 * @param request
	 * @return
	 */
	public static String getBaseUrl(HttpServletRequest request){
		String baseUrl = UtilConstant.BASE_URL;
		if(baseUrl == null || "".equals(baseUrl)){
			baseUrl = request.getRequestURL().toString().replace(request.getRequestURI(), "");
		}
		return baseUrl;
	}
	
	/**
	 * 获取完整路径
	 * @param request
	 * @return
	 */
	public static String getUrl(HttpServletRequest request){
		String url = request.getProtocol() + " ://" + request.getServerName();
		if(request.getServerPort() != 80){
			url += ":" + request.getServerPort();
		}
		url += request.getContextPath() + request.getServletPath() + "?" + (request.getQueryString());
		return url;
	}
	
	/**
	 * 获取网站基本路径
	 * @param request
	 * @return
	 */
	public static String getBasePath(HttpServletRequest request){
		String url = request.getScheme() + "://" + request.getServerName();
		if(request.getServerPort() != 80){
			url += ":" + request.getServerPort();
		}
		url += request.getContextPath();
		return url;
	}
}
