package com.crawler.wxapp.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;
import com.crawler.utils.EhCacheManager;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.wxapp.common.WxConstant;
import com.crawler.wxapp.crypt.AES;
import com.crawler.wxapp.vo.WxLoginInfo;
import com.crawler.wxapp.vo.WxSession;
import com.crawler.wxapp.vo.WxUserInfoVo;

/**
 * 微信
 * @author rubekid
 *
 * 2017年1月9日 下午4:03:31
 */
public class WxAppUtil {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(WxAppUtil.class);
	
	public static final String SESSION_CACHE_KEY_PREFIX = "wx_session_";
	
	/**
	 * 获取session
	 * @param code
	 * @return
	 */
	public static WxSession getSessionByCode(String code){
		String url = String.format(WxConstant.SESSION_URL, WxConstant.WX_APP_ID, WxConstant.WX_APP_SECRET, code);
		WxSession session =  SimpleHttpClient.getForObject(url, WxSession.class);
		if(session != null){			
			create3rdSession(session);
		}
		return session;
	}
	
	/**
	 * 根据sessionId 获取session
	 * @param sessionId
	 * @return
	 */
	public static WxSession getSessionById(String sessionId){
		EhCacheManager cacheManager = new EhCacheManager(SESSION_CACHE_KEY_PREFIX);
		return cacheManager.get(sessionId, WxSession.class);
	}
	
	
	/**
	 * 生成sessionID
	 * @param session
	 */
	public static void create3rdSession(WxSession session){
		String sessionId = RandomStringUtils.randomAlphanumeric(64);
		StringBuffer sb = new StringBuffer();
		if(session != null){
			session.setSessionId(sessionId);
			EhCacheManager cacheManager = new EhCacheManager(SESSION_CACHE_KEY_PREFIX);
			cacheManager.put(sessionId, session);
		}
	}
	
	/**
	 * 获取微信用户信息
	 * @param loginInfo
	 * @param sessionKey
	 * @return
	 */
	public static WxUserInfoVo getUserInfo(WxLoginInfo loginInfo, String sessionKey){
		try{
			AES aes = new AES();
	        byte[] resultByte = aes.decrypt(Base64.decodeBase64(loginInfo.getEncryptedData()),
	        		Base64.decodeBase64(sessionKey), Base64.decodeBase64(loginInfo.getIv()));
	        if(null != resultByte && resultByte.length > 0){
	            String userInfo = new String(resultByte, "UTF-8");
	            WxUserInfoVo userInfoVo = JSONObject.toJavaObject(JSONObject.parseObject(userInfo), WxUserInfoVo.class);
	            if(userInfoVo.getWatermark().getAppid().equals(WxConstant.WX_APP_ID)){
	            	return userInfoVo;
	            }
	        }
		}
		catch(InvalidAlgorithmParameterException | UnsupportedEncodingException ex){
			LOGGER.error(ex.getMessage(), ex);
		}
		return null;
	}

	

}
