/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class CopyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyUtils.class);

    public static <T> Page<T> translate(Page<?> page, Class<T> clazz, String ... ignoreProperties) {
        Page<T> newPage = new Page<T>(page.getPageSize(), page.getPageNo());
        List<T> items = CopyUtils.translate(page.getItems(), clazz, ignoreProperties);
        newPage.setTotalCount(page.getTotalCount());
        newPage.setItems(items);
        return newPage;
    }

    public static <T> List<T> translate(List<?> list, Class<T> clazz, String ... ignoreProperties) {
        ArrayList<T> items = new ArrayList<T>();
        int i = 0;
        while (i < list.size()) {
            items.add(CopyUtils.translate(list.get(i), clazz, ignoreProperties));
            ++i;
        }
        return items;
    }

    public static <T> T translate(Object object, Class<T> clazz, String ... ignoreProperties) {
        try {
            T item = clazz.newInstance();
            BeanUtils.copyProperties((Object)object, item, (String[])ignoreProperties);
            return item;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

