/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.beans;

import com.crawler.beans.QueryParameter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;

public class Page<T>
extends QueryParameter {
    public static final int PAGE_SIZE = 10;
    private List<T> items = new ArrayList<T>();
    private long totalCount = 0L;
    private JSONObject queryParams = new JSONObject();

    public Page() {
        this.setPageSize(10);
    }

    public Page(Integer pageSize, Integer pageNo) {
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    @JsonIgnore
    public boolean isHasNext() {
        return (long)(this.pageNo + 1) <= this.getTotalPages();
    }

    @JsonIgnore
    public int getNextPage() {
        if (this.isHasNext()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    @JsonIgnore
    public boolean isHasPre() {
        return this.pageNo - 1 >= 1;
    }

    @JsonIgnore
    public int getPrePage() {
        if (this.isHasPre()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }

    public void addQueryParam(String key, Object value) {
        this.queryParams.put((Object)key, value);
    }

    @JsonIgnore
    public String getQueryString() throws UnsupportedEncodingException {
        String result = "";
        Iterator iterator = this.queryParams.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            result = String.valueOf(result) + key + "=" + URLEncoder.encode(this.queryParams.getString(key), "utf-8") + "&";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @JsonIgnore
    public String getQueryParamString() {
        return this.queryParams.toString();
    }

    public void setQueryString(String queryString) {
        this.queryParams = JSONObject.fromObject((Object)queryString);
    }

    @JsonIgnore
    public JSONObject getQueryParams() {
        return this.queryParams;
    }
}

