/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.qrcode;

import com.crawler.common.config.ConfigProperties;
import com.crawler.qrcode.MyQRCodeImage;
import com.swetake.util.Qrcode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.exception.DecodingFailedException;

public class QRcodeUtils {
    public static final int DEFAULT_VERSION = 9;
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_JPEG = "jpg";
    public static final char CORRECT_L = 'L';
    public static final char CORRECT_M = 'M';
    public static final char CORRECT_Q = 'Q';
    public static final char CORRECT_H = 'H';
    public static final double PADDING_RATIO = 0.02;
    public static final String LOGO_PATH = ConfigProperties.getProperty("qrcode.logo");

    public static BufferedImage encode(String content, int size, int version, char ecc) throws Exception {
        int intRatio;
        int padding;
        BufferedImage image = null;
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect(ecc);
        qrcode.setQrcodeEncodeMode('B');
        qrcode.setQrcodeVersion(version);
        byte[] contentBytes = content.getBytes("utf-8");
        double ratio = 3.0;
        int qrcodeSize = 21 + 4 * (version - 1);
        if (size > 0) {
            ratio = (double)size / (double)qrcodeSize;
        }
        if ((padding = (int)Math.ceil((double)(qrcodeSize * (intRatio = (int)Math.ceil(ratio))) * 0.02)) < 5) {
            padding = 5;
        }
        int imageSize = qrcodeSize * intRatio + padding * 2;
        if ((double)intRatio > ratio) {
            int newSize = (int)Math.ceil(ratio * (double)imageSize / (double)intRatio);
            int r = newSize % 10;
            int newImageSize = (int)Math.floor((double)(intRatio * (newSize += 10 - r)) / ratio);
            padding += (newImageSize - imageSize) / 2;
            imageSize = newImageSize;
        } else {
            int r = imageSize % 10;
            int d = 10 - r;
            padding += d / 2;
            imageSize += d;
        }
        image = new BufferedImage(imageSize, imageSize, 1);
        Graphics2D gs = image.createGraphics();
        gs.setBackground(Color.WHITE);
        gs.clearRect(0, 0, imageSize, imageSize);
        gs.setColor(Color.BLACK);
        if (contentBytes.length > 0 && contentBytes.length < 800) {
            boolean[][] codeOut = qrcode.calQrcode(contentBytes);
            int i = 0;
            while (i < codeOut.length) {
                int j = 0;
                while (j < codeOut.length) {
                    if (codeOut[j][i]) {
                        gs.fillRect(j * intRatio + padding, i * intRatio + padding, intRatio, intRatio);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            throw new Exception("QRCode content bytes length = " + contentBytes.length + " not in [0, 800].");
        }
        gs.dispose();
        image.flush();
        if ((double)intRatio > ratio) {
            image = QRcodeUtils.resize(image, (int)Math.ceil(ratio * (double)imageSize / (double)intRatio));
        }
        return image;
    }

    public static BufferedImage encode(String content, int size) throws Exception {
        return QRcodeUtils.encode(content, size, 9, 'Q');
    }

    public static BufferedImage encode(String content, int size, int version) throws Exception {
        return QRcodeUtils.encode(content, size, version, 'Q');
    }

    public static BufferedImage encode(String content, int size, char ecc) throws Exception {
        return QRcodeUtils.encode(content, size, 9, ecc);
    }

    public static BufferedImage encode(String content) throws Exception {
        return QRcodeUtils.encode(content, 0, 9, 'Q');
    }

    public static String decode(BufferedImage bufferedImage) throws DecodingFailedException, UnsupportedEncodingException {
        QRCodeDecoder decoder = new QRCodeDecoder();
        return new String(decoder.decode((QRCodeImage)new MyQRCodeImage(bufferedImage)), "utf-8");
    }

    public static void download(HttpServletResponse response, String filename, String content, int size, String imageType, String logoPath) throws Exception {
        if (size > 2000) {
            size = 2000;
        }
        BufferedImage image = QRcodeUtils.encode(content, size);
        if (logoPath != null) {
            QRcodeUtils.markLogo(image, logoPath);
        }
        filename = filename.replace("{size}", String.valueOf(image.getWidth()));
        InputStream inputStream = QRcodeUtils.toInputStream(image, imageType);
        int length = inputStream.available();
        response.setContentType("application/x-msdownload");
        response.setContentLength(length);
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("gbk"), "iso-8859-1"));
        byte[] bytes = new byte[1024];
        ServletOutputStream outputStream = response.getOutputStream();
        while (inputStream.read(bytes) != -1) {
            outputStream.write(bytes);
        }
        outputStream.flush();
    }

    public static void download(HttpServletResponse response, String filename, String content, int size, String imageType) throws Exception {
        QRcodeUtils.download(response, filename, content, size, imageType, null);
    }

    public static void download(HttpServletResponse response, String filename, String content, int size) throws Exception {
        QRcodeUtils.download(response, filename, content, size, IMAGE_TYPE_PNG);
    }

    public static void createQrcodeFile(File destFile, String content, int version, int size) throws Exception {
        if (!destFile.exists() || !destFile.isFile()) {
            destFile.createNewFile();
        }
        FileOutputStream outputStream = new FileOutputStream(destFile);
        BufferedImage image = QRcodeUtils.encode(content, size, version, 'H');
        QRcodeUtils.markLogo(image, LOGO_PATH);
        InputStream inputStream = QRcodeUtils.toInputStream(image, IMAGE_TYPE_PNG);
        byte[] bytes = new byte[1024];
        while (inputStream.read(bytes) != -1) {
            ((OutputStream)outputStream).write(bytes);
        }
        inputStream.close();
        ((OutputStream)outputStream).close();
    }

    public static InputStream createInputStream(String content, int version, int size) throws Exception {
        BufferedImage image = QRcodeUtils.encode(content, size, version, 'L');
        return QRcodeUtils.toInputStream(image, IMAGE_TYPE_PNG);
    }

    public static InputStream getInputStream(String content, int version, int size) throws Exception {
        BufferedImage image = QRcodeUtils.encode(content, size, version, 'H');
        QRcodeUtils.markLogo(image, LOGO_PATH);
        return QRcodeUtils.toInputStream(image, IMAGE_TYPE_PNG);
    }

    public static void markLogo(BufferedImage qrcode, String logoPath) throws IOException {
        if (logoPath == null) {
            return;
        }
        File logoFile = new File(logoPath);
        if (logoFile.exists()) {
            Graphics2D gs = qrcode.createGraphics();
            int width = qrcode.getWidth();
            int height = qrcode.getHeight();
            BufferedImage logo = ImageIO.read(logoFile);
            logo = QRcodeUtils.setRadius(logo);
            float scale = 3.5f;
            int lw = (int)((float)width / scale);
            int lh = (int)((float)height / scale);
            int wx = (width - lw) / 2;
            int wy = (height - lh) / 2;
            gs.setComposite(AlphaComposite.getInstance(10, 1.0f));
            gs.drawImage(logo, wx, wy, lw, lh, null);
            gs.dispose();
            qrcode.flush();
        }
    }

    public static InputStream getQrcodeImageStream(String content, int size, String imageType, String logoPath) throws Exception {
        if (size > 2000) {
            size = 2000;
        }
        BufferedImage image = QRcodeUtils.encode(content, size);
        if (logoPath != null) {
            QRcodeUtils.markLogo(image, logoPath);
        }
        return QRcodeUtils.toInputStream(image, imageType);
    }

    public static InputStream getQrcodeImageStream(String content, int size, String imageType) throws Exception {
        return QRcodeUtils.getQrcodeImageStream(content, size, imageType, null);
    }

    public static InputStream toInputStream(BufferedImage image, String imageType) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);
        if (IMAGE_TYPE_JPEG.equals(imageType)) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(1.0f);
            imageWriter.setOutput(imageOutput);
            IIOImage iioImage = new IIOImage(image, null, null);
            imageWriter.write(null, iioImage, imageWriteParam);
            imageWriter.dispose();
        } else {
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_PNG, imageOutput);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static BufferedImage resize(BufferedImage image, int size) {
        int imageSize = size % 2 > 0 ? size + 1 : size;
        BufferedImage bufferedImage = new BufferedImage(imageSize, imageSize, 1);
        Graphics2D gs = bufferedImage.createGraphics();
        gs.setBackground(Color.WHITE);
        gs.clearRect(0, 0, imageSize, imageSize);
        gs.setColor(Color.BLACK);
        gs.fillRect(0, 0, imageSize, imageSize);
        gs.drawImage(image, 0, 0, size, size, null);
        gs.dispose();
        image.flush();
        return bufferedImage;
    }

    public static void show(HttpServletResponse response, String content, int size) throws Exception {
        if (size > 2000) {
            size = 2000;
        }
        BufferedImage image = QRcodeUtils.encode(content, size, 9, 'H');
        QRcodeUtils.markLogo(image, LOGO_PATH);
        InputStream inputStream = QRcodeUtils.toInputStream(image, IMAGE_TYPE_PNG);
        int length = inputStream.available();
        response.setContentLength(length);
        byte[] bytes = new byte[1024];
        ServletOutputStream outputStream = response.getOutputStream();
        while (inputStream.read(bytes) != -1) {
            outputStream.write(bytes);
        }
        outputStream.flush();
    }

    public static BufferedImage setRadius(BufferedImage srcImage, int radius, int border, int padding) throws IOException {
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int canvasWidth = width + padding * 2;
        int canvasHeight = height + padding * 2;
        BufferedImage image = new BufferedImage(canvasWidth, canvasHeight, 2);
        Graphics2D gs = image.createGraphics();
        gs.setComposite(AlphaComposite.Src);
        gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gs.setColor(Color.WHITE);
        gs.fill(new RoundRectangle2D.Float(0.0f, 0.0f, canvasWidth, canvasHeight, radius, radius));
        gs.setComposite(AlphaComposite.SrcAtop);
        gs.drawImage((Image)QRcodeUtils.setClip(srcImage, radius), padding, padding, null);
        if (border != 0) {
            gs.setColor(new Color(240, 240, 240));
            gs.setStroke(new BasicStroke(border));
            gs.drawRoundRect(padding, padding, canvasWidth - 2 * padding - 1, canvasHeight - 2 * padding - 1, radius, radius);
        }
        gs.dispose();
        return image;
    }

    public static BufferedImage setRadius(BufferedImage srcImage) throws IOException {
        return QRcodeUtils.setRadius(srcImage, 2);
    }

    public static BufferedImage setRadius(BufferedImage srcImage, int strokeWidth) throws IOException {
        int radius = (srcImage.getWidth() + srcImage.getHeight()) / 7;
        return QRcodeUtils.setRadius(srcImage, radius, strokeWidth, 5);
    }

    public static BufferedImage setClip(BufferedImage srcImage, int radius) {
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D gs = image.createGraphics();
        gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gs.setClip(new RoundRectangle2D.Double(0.0, 0.0, width, height, radius, radius));
        gs.drawImage((Image)srcImage, 0, 0, null);
        gs.dispose();
        return image;
    }
}

