/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.common.config.ConfigProperties;
import com.crawler.utils.ReflectionUtils;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;

public abstract class EhCacheService<T, PK extends Serializable> {
    private static final String EHCACHE_NAME = ConfigProperties.getProperty("ehcache.name");
    @Autowired
    protected EhCacheCacheManager cacheManager;
    protected Class<T> entityClass = ReflectionUtils.getSuperClassGenricType(this.getClass());
    protected String prefix = String.valueOf(this.entityClass.getName().toLowerCase()) + ":";

    public abstract T get(PK var1);

    public T getCache(PK id) {
        T t = this.getCache(this.getKey(id), this.entityClass);
        if (t == null) {
            t = this.get(id);
            this.setCahce(id, t);
        }
        return t;
    }

    public void setCahce(PK id, Object value) {
        this.setCahce(this.getKey(id), value);
    }

    public <T> T getCache(String key, Class<T> clazz) {
        Cache cache = this.cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get((Object)key);
        if (value == null) {
            return null;
        }
        return (T)value.get();
    }

    public void setCahce(String key, Object value) {
        Cache cache = this.cacheManager.getCache(EHCACHE_NAME);
        if (value != null) {
            cache.put((Object)key, value);
        }
    }

    public String getKey(PK id) {
        return String.valueOf(this.prefix) + id;
    }
}

