/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Page;
import com.crawler.common.config.JacksonObjectMapper;
import com.crawler.exception.SimpleRuntimeException;
import com.crawler.utils.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisManager {
    private static Logger logger = LoggerFactory.getLogger(RedisManager.class);
    private static int WAIT_TIMEOUT_MSECS = 60000;
    private static int LOCK_EXPIRE_MSECS = 60000;
    private static JedisPool pool;
    private static int DB_INDEX;

    static {
        DB_INDEX = 0;
        try {
            Properties props = new Properties();
            props.load(RedisManager.class.getClassLoader().getResourceAsStream("redis.properties"));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.valueOf(props.getProperty("redis.pool.maxTotal")).intValue());
            config.setMaxIdle(Integer.valueOf(props.getProperty("redis.pool.maxIdle")).intValue());
            config.setMaxWaitMillis(Long.valueOf(props.getProperty("redis.pool.maxWaitMillis")).longValue());
            config.setTestOnBorrow(Boolean.valueOf(props.getProperty("redis.pool.testOnBorrow")).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(props.getProperty("redis.pool.testOnReturn")).booleanValue());
            String host = props.getProperty("redis.host");
            Integer port = Integer.valueOf(props.getProperty("redis.port"));
            Integer timeout = Integer.valueOf(props.getProperty("redis.timeout"));
            String password = props.getProperty("redis.password");
            DB_INDEX = Integer.valueOf(props.getProperty("redis.dbindex", "0"));
            pool = password != null ? new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue(), password) : new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(String lockKey, Integer waitTimeout) {
        start = System.currentTimeMillis();
        jedis = null;
        try {
            jedis = RedisManager.getJedis();
            if (waitTimeout == null) {
                waitTimeout = RedisManager.WAIT_TIMEOUT_MSECS;
            }
            while (true) {
                time = System.currentTimeMillis() + (long)RedisManager.LOCK_EXPIRE_MSECS + 1L;
                expireAt = String.valueOf(time);
                if (jedis.setnx(lockKey, expireAt) == 1L) {
                    return true;
                }
                currentValue = jedis.get(lockKey);
                if (currentValue != null && Long.parseLong(currentValue) < System.currentTimeMillis() && (oldValue = jedis.getSet(lockKey, expireAt)) != null && oldValue.equals(currentValue)) {
                    return true;
                }
                waitTimeout = waitTimeout - 100;
                try {
                    if (waitTimeout >= 0) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException ex) {
                    RedisManager.logger.error(ex.getMessage(), (Throwable)ex);
                }
                break;
            }
        }
        finally {
            if (waitTimeout >= 0) ** continue;
            return false;
        }
    }

    public static boolean lock(String lockKey) {
        return RedisManager.lock(lockKey, null);
    }

    public static void unlock(String lockKey) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.del(lockKey);
        }
    }

    public static void batchDeleteByKey(String prefix) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set set = jedis.keys(String.valueOf(prefix) + "*");
            Iterator it = set.iterator();
            ArrayList<String> keys = new ArrayList<String>();
            while (it.hasNext()) {
                keys.add((String)it.next());
                if (keys.size() <= 0 || keys.size() % 100 != 0) continue;
                jedis.del(keys.toArray(new String[keys.size()]));
                keys.clear();
            }
            if (keys.size() > 0) {
                jedis.del(keys.toArray(new String[keys.size()]));
            }
        }
    }

    public static synchronized Jedis getJedis() {
        Jedis resource = null;
        try {
            if (pool != null) {
                resource = pool.getResource();
                resource.select(DB_INDEX);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (resource == null) {
            throw new NullPointerException("jedis is null, please check the redis server.");
        }
        return resource;
    }

    public static void close(Jedis jedis) {
        jedis.close();
    }

    public static String get(String key, String defaultValue) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.get(key);
            String string = value == null ? defaultValue : value;
            return string;
        }
    }

    public static void set(String key, String value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.set(key, value);
        }
    }

    public static void set(String key, Object data, int seconds) {
        String value = null;
        value = data instanceof String ? String.valueOf(data) : RedisManager.toJSONString(data);
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.setex(key, seconds, value);
        }
        finally {
            RedisManager.close(jedis);
        }
    }

    public static <T> T get(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.get(key);
            if (StringUtils.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
    }

    public static <T> List<T> findList(String key, Class<T> clazz, String ... exceptKeys) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            List data = new ArrayList();
            if (key.contains("*")) {
                Set keys = jedis.keys(key);
                List<String> exceptKeyList = Arrays.asList(exceptKeys);
                for (String k : keys) {
                    if (exceptKeyList.contains(k)) continue;
                    data.addAll(jedis.lrange(k, 0L, -1L));
                }
            } else {
                data = jedis.lrange(key, 0L, -1L);
            }
            ArrayList<T> list = new ArrayList<T>();
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }

    public static Page<T> findPage(Page<T> page, String key) {
        try (Jedis jedis = null;){
            int start = page.getFirst();
            int end = start + page.getPageSize();
            jedis = RedisManager.getJedis();
            List data = jedis.lrange(key, (long)start, (long)end);
            ArrayList<T> list = new ArrayList<T>();
            for (String string : data) {
                list.add(RedisManager.parse(string, T.class));
            }
            page.setItems(list);
            Page<T> page2 = page;
            return page2;
        }
    }

    public static void put(String key, Object data) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.set(key, RedisManager.toJSONString(data));
        }
    }

    public static <E> void setList(String key, List<E> list) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                jedis.del(key);
                String[] strings = StringUtils.toStrings(list);
                if (strings.length > 0) {
                    jedis.rpush(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static void insert(String key, Object item) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.rpush(key, new String[]{RedisManager.toJSONString(item)});
        }
    }

    public static Set<String> keys(String pattern) {
        try (Jedis jedis = null;){
            Set keys;
            jedis = RedisManager.getJedis();
            Set set = keys = jedis.keys(pattern);
            return set;
        }
    }

    public static void set(String key, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.set(key, RedisManager.toJSONString(obj));
        }
    }

    public static void lset(String key, int index, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.lset(key, (long)index, RedisManager.toJSONString(obj));
        }
    }

    public static void remove(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.del(key);
        }
    }

    public static void publish(String channel, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String data = RedisManager.toJSONString(obj);
            System.out.println("================== \u53d1\u5e03\u6d88\u606f ========================");
            System.out.println(String.valueOf(channel) + " " + data);
            jedis.publish(channel, data);
            System.out.println("================== \u53d1\u5e03\u6d88\u606f\u7ed3\u675f ========================");
        }
    }

    public static void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.subscribe(jedisPubSub, channels);
        }
    }

    public static <T> T pop(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.lpop(key);
            if (StringUtils.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
    }

    public static String toJSONString(Object object) {
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    public static <T> T parse(String value, Class<T> clazz) {
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return (T)objectMapper.readValue(value, clazz);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

