/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.web;

import com.crawler.common.config.UtilConstant;
import com.crawler.utils.EhCacheManager;
import com.crawler.utils.StringUtils;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.web.AccessToken;
import com.crawler.weixin.web.FansUserInfo;
import com.crawler.weixin.web.QrcodeResponse;
import com.crawler.weixin.web.Ticket;
import com.crawler.weixin.web.UserAccessToken;
import com.crawler.weixin.web.UserInfo;
import com.crawler.weixin.web.WxJsConfig;
import com.crawler.weixin.web.enums.QrcodeActionName;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;

public class WeixinWebUtils {
    private static final String WECHAT_CACHE_NAME = "wechat-cache";
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String USER_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String USERINFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";
    private static final String AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect";
    private static final String FANS_USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN";
    private static final String CREATE_QRCODE = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";

    public static UserAccessToken getUserAccessToken(String appId, String appSecret, String code) {
        String url = String.format(USER_ACCESS_TOKEN_URL, appId, appSecret, code);
        return SimpleHttpClient.getForObject(url, UserAccessToken.class);
    }

    public static UserInfo getUserInfo(String accessToken, String openid) {
        String url = String.format(USERINFO_URL, accessToken, openid);
        return SimpleHttpClient.getForObject(url, UserInfo.class);
    }

    public static AccessToken getAccessToken(String appId, String appSecret) {
        EhCacheManager ehCacheManager = new EhCacheManager(WECHAT_CACHE_NAME, "acccess_token");
        String key = String.format("%s_%s", appId, appSecret);
        AccessToken accessToken = ehCacheManager.get(key, AccessToken.class);
        if (accessToken == null || accessToken.getExpireAt().before(new Date())) {
            String url = String.format(ACCESS_TOKEN_URL, appId, appSecret);
            accessToken = SimpleHttpClient.getForObject(url, AccessToken.class);
            accessToken.setExpireAt(new Date(System.currentTimeMillis() + (long)accessToken.getExpiresIn().intValue()));
            ehCacheManager.put(key, accessToken);
        }
        return accessToken;
    }

    public static Ticket getTicket(String accessToken) {
        EhCacheManager ehCacheManager = new EhCacheManager(WECHAT_CACHE_NAME, "ticket");
        Ticket ticket = ehCacheManager.get(accessToken, Ticket.class);
        if (ticket == null || ticket.getExpireAt().before(new Date())) {
            String url = String.format(TICKET_URL, accessToken);
            ticket = SimpleHttpClient.getForObject(url, Ticket.class);
            ticket.setExpireAt(new Date(System.currentTimeMillis() + (long)ticket.getExpiresIn().intValue()));
            ehCacheManager.put(accessToken, ticket);
        }
        return ticket;
    }

    public static WxJsConfig signature(String url) {
        return WeixinWebUtils.signature(UtilConstant.WECHAT_APPID, UtilConstant.WECHAT_APPSECRET, url);
    }

    public static WxJsConfig signature(String appId, String secret, String url) {
        WxJsConfig wxJsConfig = new WxJsConfig();
        wxJsConfig.setAppId(appId);
        wxJsConfig.setNonceStr(StringUtils.getRandomString(16));
        wxJsConfig.setTimestamp(System.currentTimeMillis() / 1000L);
        AccessToken accessToken = WeixinWebUtils.getAccessToken(appId, secret);
        Ticket ticket = WeixinWebUtils.getTicket(accessToken.getAccessToken());
        String str = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", ticket.getTicket(), wxJsConfig.getNonceStr(), wxJsConfig.getTimestamp(), url);
        String signature = DigestUtils.shaHex((byte[])str.getBytes());
        wxJsConfig.setSignature(signature);
        return wxJsConfig;
    }

    public static void authorize(HttpServletResponse response, String redirectUrl) throws IOException {
        String location = String.format(AUTHORIZE_URL, UtilConstant.WECHAT_APPID, redirectUrl);
        response.sendRedirect(location);
    }

    public static FansUserInfo getFansUserInfo(String accessToken, String openid) {
        String url = String.format(FANS_USER_INFO_URL, accessToken, openid);
        return SimpleHttpClient.getForObject(url, FansUserInfo.class);
    }

    public static FansUserInfo getFansUserInfo(String openid) {
        AccessToken accessToken = WeixinWebUtils.getAccessToken(UtilConstant.WECHAT_APPID, UtilConstant.WECHAT_APPSECRET);
        return WeixinWebUtils.getFansUserInfo(accessToken.getAccessToken(), openid);
    }

    public static QrcodeResponse createQrcode(QrcodeActionName actionName, String sceneId, Integer expireSeconds) {
        JSONObject scene = new JSONObject();
        if (StringUtils.isNumeric(sceneId)) {
            scene.put((Object)"scene_id", (Object)Long.parseLong(sceneId));
        } else {
            scene.put((Object)"scene_str", (Object)sceneId);
        }
        JSONObject body = new JSONObject();
        JSONObject actionInfo = new JSONObject();
        actionInfo.put((Object)"scene", (Object)scene);
        body.put((Object)"action_name", (Object)actionName);
        if ((actionName.equals((Object)QrcodeActionName.QR_SCENE) || actionName.equals((Object)QrcodeActionName.QR_STR_SCENE)) && expireSeconds != null) {
            body.put((Object)"expire_seconds", (Object)expireSeconds);
        }
        body.put((Object)"action_info", (Object)actionInfo);
        AccessToken accessToken = WeixinWebUtils.getAccessToken(UtilConstant.WECHAT_APPID, UtilConstant.WECHAT_APPSECRET);
        String url = String.format(CREATE_QRCODE, accessToken.getAccessToken());
        return SimpleHttpClient.postForObject(url, body, QrcodeResponse.class);
    }
}

