/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.wxapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.crawler.utils.EhCacheManager;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.wxapp.common.WxConstant;
import com.crawler.wxapp.crypt.AES;
import com.crawler.wxapp.vo.WxLoginInfo;
import com.crawler.wxapp.vo.WxSession;
import com.crawler.wxapp.vo.WxUserInfoVo;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxAppUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxAppUtil.class);
    public static final String SESSION_CACHE_KEY_PREFIX = "wx_session_";

    public static WxSession getSessionByCode(String code) {
        String url = String.format("https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code", WxConstant.WX_APP_ID, WxConstant.WX_APP_SECRET, code);
        WxSession session = SimpleHttpClient.getForObject(url, WxSession.class);
        if (session != null) {
            WxAppUtil.create3rdSession(session);
        }
        return session;
    }

    public static WxSession getSessionById(String sessionId) {
        EhCacheManager cacheManager = new EhCacheManager(SESSION_CACHE_KEY_PREFIX);
        return cacheManager.get(sessionId, WxSession.class);
    }

    public static void create3rdSession(WxSession session) {
        String sessionId = RandomStringUtils.randomAlphanumeric((int)64);
        StringBuffer sb = new StringBuffer();
        if (session != null) {
            session.setSessionId(sessionId);
            EhCacheManager cacheManager = new EhCacheManager(SESSION_CACHE_KEY_PREFIX);
            cacheManager.put(sessionId, session);
        }
    }

    public static WxUserInfoVo getUserInfo(WxLoginInfo loginInfo, String sessionKey) {
        try {
            String userInfo;
            WxUserInfoVo userInfoVo;
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64((String)loginInfo.getEncryptedData()), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)loginInfo.getIv()));
            if (resultByte != null && resultByte.length > 0 && (userInfoVo = (WxUserInfoVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)(userInfo = new String(resultByte, "UTF-8"))), WxUserInfoVo.class)).getWatermark().getAppid().equals(WxConstant.WX_APP_ID)) {
                return userInfoVo;
            }
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

