/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.auth;

import com.crawler.client.auth.BearerTokenService;
import com.crawler.client.auth.UserCenterAccount;
import com.crawler.client.entity.BearerToken;
import com.crawler.client.http.RestHttpClient;
import com.crawler.client.util.UrlUtil;
import com.crawler.uc.config.UcConstant;
import com.crawler.uc.utils.UcSimulator;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;
import java.util.Date;
import org.springframework.web.client.RestClientException;

public class BearerTokenServiceImpl
implements BearerTokenService {
    public static final String UC_API_REFRESH_TOKEN = "uc.api.refresh_token";
    public static final String UC_API_POST_BEARER_TOKEN = "uc.api.post_bearer_token";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME = "client.bearerToken.account.username";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD = "client.bearerToken.account.password";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_APPID = "app.id";
    private static final String UC_API_REFRESH_TOKEN_VALUE = "bearer_token/refresh";
    private static final String UC_API_POST_BEARER_TOKEN_VALUE = "bearer_token";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE = "bearer";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE = "7d1ee5f6f44e25ec9056db37eeac517c";
    private RestHttpClient httpClient = new RestHttpClient();

    public RestHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(RestHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public BearerToken getBearerToken() throws RestClientException {
        BearerToken bearerToken = null;
        if (UcConstant.UC_ENABLE) {
            UserCenterAccount ucAccount;
            String uri = this.getPostBearerTokenUri();
            WafAccessToken accessToken = this.httpClient.postForObject(uri, (Object)(ucAccount = this.getUCAccount()), WafAccessToken.class, new Object[0]);
            if (accessToken != null) {
                bearerToken = accessToken.toBearerToken();
            }
        } else {
            OauthAccessToken oauthAccessToken = UcSimulator.generate(0L, "Bearer");
            bearerToken = new BearerToken(oauthAccessToken.getUserId(), oauthAccessToken.getAccessToken(), oauthAccessToken.getRefreshToken(), oauthAccessToken.getExpiresAt());
        }
        return bearerToken;
    }

    @Override
    public BearerToken refreshBearerToken(BearerToken bearerToken) throws RestClientException {
        BearerToken refreshBearerToken = null;
        String uri = this.getRefreshTokenUri(bearerToken.getRefreshToken());
        WafAccessToken accessToken = this.httpClient.getForObject(uri, WafAccessToken.class, new Object[0]);
        if (accessToken != null) {
            refreshBearerToken = accessToken.toBearerToken();
        }
        return refreshBearerToken;
    }

    private String getRefreshTokenUri(String refreshToken) {
        return UrlUtil.combine(this.getProperty("uc.uri"), this.getProperty(UC_API_REFRESH_TOKEN, UC_API_REFRESH_TOKEN_VALUE)) + "/" + refreshToken;
    }

    private String getPostBearerTokenUri() {
        return UrlUtil.combine(this.getProperty("uc.uri"), this.getProperty(UC_API_POST_BEARER_TOKEN, UC_API_POST_BEARER_TOKEN_VALUE));
    }

    private UserCenterAccount getUCAccount() {
        return new UserCenterAccount(this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME, CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE), this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD, CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE), this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_APPID));
    }

    private String getProperty(String key) {
        return WafProperties.getProperty(key);
    }

    private String getProperty(String key, String defaultValue) {
        return WafProperties.getProperty(key, defaultValue);
    }

    private static class WafAccessToken {
        private String userId;
        private String accessToken;
        private Date expiresAt;
        private String refreshToken;

        private WafAccessToken() {
        }

        public String getUserId() {
            return this.userId;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public BearerToken toBearerToken() {
            return new BearerToken(this.getUserId(), this.getAccessToken(), this.getRefreshToken(), this.getExpiresAt());
        }
    }
}

