/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.component;

import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResponseAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void response() {
    }

    @Around(value="response()")
    public Object responseHandler(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj = joinPoint.proceed();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (obj instanceof List && method.getReturnType().equals(Object.class)) {
            try {
                return new ItemsVo((List)obj);
            }
            catch (RuntimeException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return obj;
    }

    public class ItemsVo {
        private List<?> items;

        public ItemsVo() {
        }

        public ItemsVo(List<?> items) {
            this.items = items;
        }

        public List<?> getItems() {
            return this.items;
        }

        public void setItems(List<?> items) {
            this.items = items;
        }
    }
}

