/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.uc.listener;

import com.alibaba.fastjson.JSONObject;
import com.crawler.component.SpringContextUtil;
import com.crawler.uc.push.EventPushBody;
import com.crawler.uc.push.event.KickEvent;
import com.crawler.uc.utils.UcRedisManager;
import com.crawler.waf.listener.RedisPubSubListener;
import com.crawler.waf.security.services.impl.UserCenterBearerTokenCacheService;
import com.crawler.waf.security.services.impl.UserCenterMacTokenCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCPubSubListener
extends RedisPubSubListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void onMessage(String channel, String message) {
        try {
            EventPushBody body;
            if ("UC".equals(channel) && (body = UcRedisManager.parse(message, EventPushBody.class)) != null) {
                String data = JSONObject.toJSONString((Object)body.getData());
                KickEvent event = (KickEvent)JSONObject.parseObject((String)data, KickEvent.class);
                if ("MAC".equals(event.getType())) {
                    UserCenterMacTokenCacheService userCenterMacTokenCacheService = SpringContextUtil.getBean(UserCenterMacTokenCacheService.class);
                    userCenterMacTokenCacheService.removeCache(event.getAccessToken());
                } else if ("Bearer".equals(event.getType())) {
                    UserCenterBearerTokenCacheService userCenterBearerTokenCacheService = SpringContextUtil.getBean(UserCenterBearerTokenCacheService.class);
                    userCenterBearerTokenCacheService.removeCache(event.getAccessToken());
                }
            }
        }
        catch (RuntimeException ex) {
            this.logger.error(ex.getMessage());
        }
    }
}

