/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.uc.utils;

import com.crawler.component.SpringContextUtil;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import com.crawler.waf.security.authens.BaseUserInfo;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.support.WafContext;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.http.HttpStatus;

public class UcManager {
    private static EhCacheCacheManager cacheManager = SpringContextUtil.getBean(EhCacheCacheManager.class);
    private static final String EHCACHE_NAME = WafProperties.getProperty("user.ehcache.name");
    private static final String KEY_PREFIX = "user_";

    public static Long getUserId() {
        return UcManager.getUserId(false);
    }

    public static Long getUserId(boolean anonymous) {
        BaseUserInfo baseUserInfo = WafContext.getCurrertUserInfo();
        if (baseUserInfo == null) {
            if (anonymous) {
                return null;
            }
            throw new WafSimpleException(HttpStatus.FORBIDDEN, "WAF/ACCESS_DENIED", "\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c");
        }
        return baseUserInfo.getUserId();
    }

    public static OauthAccessToken getUcToken() {
        return WafContext.getCurrentToken();
    }

    public static BaseUserInfo getUserInfo() {
        return WafContext.getCurrertUserInfo();
    }

    public static <T> T getLocalUser(Long userId, Class<T> clazz) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get((Object)UcManager.getKey(userId));
        if (value == null) {
            return null;
        }
        return (T)value.get();
    }

    public static <T> T getLocalUser(Class<T> clazz) {
        return UcManager.getLocalUser(UcManager.getUserId(), clazz);
    }

    public static void setLocalUser(Long userId, Object value) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        if (value != null) {
            cache.put((Object)UcManager.getKey(userId), value);
        }
    }

    public static void setLocalUser(Object value) {
        Long userId = UcManager.getUserId(true);
        if (userId != null) {
            UcManager.setLocalUser(userId, value);
        }
    }

    public static String getKey(Long userId) {
        return KEY_PREFIX + userId;
    }
}

