/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf;

import com.crawler.waf.config.WafProperties;
import com.crawler.waf.filter.CorsFilter;
import com.crawler.waf.filter.ExceptionFilter;
import com.crawler.waf.filter.HttpMethodOverrideFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

@Order(value=1)
public abstract class AbstractWebBaseApplicationInitializer
extends AbstractAnnotationConfigDispatcherServletInitializer {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected boolean disableSecurity = false;

    protected String[] getServletMappings() {
        return new String[]{"/"};
    }

    public boolean isDisableSecurity() {
        return this.disableSecurity;
    }

    public void setDisableSecurity(boolean disableSecurity) {
        this.disableSecurity = disableSecurity;
    }

    protected void customizeRegistration(ServletRegistration.Dynamic registration) {
        registration.setInitParameter("throwExceptionIfNoHandlerFound", "true");
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        System.setProperty("http.maxConnections", "100");
        servletContext.setInitParameter("disableSecurity", String.valueOf(this.isDisableSecurity()));
        super.onStartup(servletContext);
        this.initCharacterEncodingFilter(servletContext);
        this.initCorsFilter(servletContext);
        this.initHiddenHttpMethodFilter(servletContext);
        this.initExceptionFilter(servletContext);
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        WafProperties.getProperties().list(printWriter);
        this.logger.info(((Object)result).toString());
    }

    protected void initCharacterEncodingFilter(ServletContext servletContext) {
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setForceEncoding(true);
        characterEncodingFilter.setEncoding("UTF-8");
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter("characterEncodingFilter", (Filter)characterEncodingFilter);
        filterRegistration.setAsyncSupported(this.isAsyncSupported());
        filterRegistration.addMappingForUrlPatterns(this.getDispatcherTypes(), false, new String[]{"/*"});
    }

    protected void initHiddenHttpMethodFilter(ServletContext servletContext) {
        FilterRegistration.Dynamic hiddenHttpMethodFilter = servletContext.addFilter("hiddenHttpMethodFilter", (Filter)new HttpMethodOverrideFilter());
        hiddenHttpMethodFilter.setAsyncSupported(this.isAsyncSupported());
        hiddenHttpMethodFilter.addMappingForUrlPatterns(this.getDispatcherTypes(), false, new String[]{"/*"});
    }

    protected void initCorsFilter(ServletContext servletContext) {
        this.logger.info("AbstractWebBaseApplicationInitializer init CorsFilter start");
        FilterRegistration.Dynamic corsFilter = servletContext.addFilter("corsFilter", (Filter)new CorsFilter());
        corsFilter.setAsyncSupported(this.isAsyncSupported());
        corsFilter.addMappingForUrlPatterns(this.getDispatcherTypes(), false, new String[]{"/*"});
    }

    protected void initExceptionFilter(ServletContext servletContext) {
        FilterRegistration.Dynamic exceptionFilter = servletContext.addFilter("exceptionFilter", (Filter)new ExceptionFilter());
        exceptionFilter.setAsyncSupported(this.isAsyncSupported());
        exceptionFilter.addMappingForUrlPatterns(this.getDispatcherTypes(), false, new String[]{"/*"});
    }

    protected EnumSet<DispatcherType> getDispatcherTypes() {
        return this.isAsyncSupported() ? EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.ASYNC) : EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE);
    }
}

