/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.clientcache;

import com.crawler.waf.annotations.CacheControl;
import com.crawler.waf.annotations.Etag;
import com.crawler.waf.clientcache.CachePolicy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.WebUtils;

public class CacheControlHandlerInterceptor
extends HandlerInterceptorAdapter
implements HandlerInterceptor {
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static String HEADER_ETAG = "ETag";
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";
    private boolean useExpiresHeader = true;
    private static final Logger logger = LoggerFactory.getLogger(CacheControlHandlerInterceptor.class);

    protected final void assignCacheControlHeader(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        CacheControl cacheControl = this.getCacheControl(request, response, handler);
        String cacheControlHeader = this.createCacheControlHeader(cacheControl);
        if (cacheControlHeader != null) {
            response.setHeader(HEADER_CACHE_CONTROL, cacheControlHeader);
            if (this.useExpiresHeader) {
                response.setDateHeader(HEADER_EXPIRES, this.createExpiresHeader(cacheControl));
            }
        }
        if (this.enabledEtag(request, response, handler)) {
            this.updateResponse(request, (HttpServletResponse)new ShallowEtagResponseWrapper(response));
        }
    }

    protected final String createCacheControlHeader(CacheControl cacheControl) {
        StringBuilder builder = new StringBuilder();
        if (cacheControl == null) {
            return null;
        }
        CachePolicy[] policies = cacheControl.policy();
        if (cacheControl.maxAge() >= 0) {
            builder.append("max-age=").append(cacheControl.maxAge());
        }
        if (cacheControl.sMaxAge() >= 0) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("s-maxage=").append(cacheControl.sMaxAge());
        }
        if (policies != null) {
            for (CachePolicy policy : policies) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(policy.policy());
            }
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    protected final long createExpiresHeader(CacheControl cacheControl) {
        GregorianCalendar expires = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        if (cacheControl.maxAge() >= 0) {
            ((Calendar)expires).add(13, cacheControl.maxAge());
        }
        return expires.getTime().getTime();
    }

    public final CacheControl getCacheControl(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler == null || !(handler instanceof HandlerMethod)) {
            return null;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        CacheControl cacheControl = (CacheControl)handlerMethod.getMethodAnnotation(CacheControl.class);
        if (cacheControl == null) {
            return handlerMethod.getBeanType().getAnnotation(CacheControl.class);
        }
        return cacheControl;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.assignCacheControlHeader(request, response, handler);
        return super.preHandle(request, response, handler);
    }

    public final void setUseExpiresHeader(boolean useExpiresHeader) {
        this.useExpiresHeader = useExpiresHeader;
    }

    private void updateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ShallowEtagResponseWrapper responseWrapper = (ShallowEtagResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)response, ShallowEtagResponseWrapper.class));
        Assert.notNull((Object)((Object)responseWrapper), (String)"ShallowEtagResponseWrapper not found");
        response = (HttpServletResponse)responseWrapper.getResponse();
        byte[] body = responseWrapper.toByteArray();
        int statusCode = responseWrapper.getStatusCode();
        if (this.isEligibleForEtag(request, (HttpServletResponse)responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            response.setHeader(HEADER_ETAG, responseETag);
            String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (logger.isInfoEnabled()) {
                    logger.info("ETag [" + responseETag + "] equal to If-None-Match, sending 304");
                }
                response.setStatus(304);
            } else {
                logger.info("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response");
                this.copyBodyToResponse(body, response);
            }
        } else {
            logger.info("Response with status code [" + statusCode + "] not eligible for ETag");
            this.copyBodyToResponse(body, response);
        }
    }

    private void copyBodyToResponse(byte[] body, HttpServletResponse response) throws IOException {
        if (body.length > 0) {
            response.setContentLength(body.length);
            FileCopyUtils.copy((byte[])body, (OutputStream)response.getOutputStream());
        }
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, byte[] responseBody) {
        return responseStatusCode >= 200 && responseStatusCode < 300;
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }

    protected final boolean enabledEtag(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler == null || !(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Etag etag = (Etag)handlerMethod.getMethodAnnotation(Etag.class);
        if (etag == null) {
            if (handlerMethod.getBeanType().isAnnotation()) {
                return handlerMethod.getBeanType().getAnnotation(Etag.class).enabled();
            }
            return false;
        }
        return etag.enabled();
    }

    private static class ShallowEtagResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream content = new ByteArrayOutputStream();
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;
        private int statusCode = 200;

        private ShallowEtagResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.statusCode = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.statusCode = sc;
        }

        public void sendError(int sc) throws IOException {
            super.sendError(sc);
            this.statusCode = sc;
        }

        public void sendError(int sc, String msg) throws IOException {
            super.sendError(sc, msg);
            this.statusCode = sc;
        }

        public void setContentLength(int len) {
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
            }
            return this.writer;
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.resetBuffer();
        }

        private int getStatusCode() {
            return this.statusCode;
        }

        private byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private class ResponsePrintWriter
        extends PrintWriter {
            private ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
                super(new OutputStreamWriter((OutputStream)ShallowEtagResponseWrapper.this.content, characterEncoding));
            }

            @Override
            public void write(char[] buf, int off, int len) {
                super.write(buf, off, len);
                super.flush();
            }

            @Override
            public void write(String s, int off, int len) {
                super.write(s, off, len);
                super.flush();
            }

            @Override
            public void write(int c) {
                super.write(c);
                super.flush();
            }
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b, off, len);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener arg0) {
            }
        }
    }
}

