/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.clientcache;

import com.crawler.waf.annotations.LastModifiedCache;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class LastModifiedRequestMappingHandlerAdapter
extends RequestMappingHandlerAdapter {
    protected long getLastModifiedInternal(HttpServletRequest request, HandlerMethod handlerMethod) {
        if (handlerMethod instanceof LastModified) {
            return ((LastModified)handlerMethod).getLastModified(request);
        }
        if (this.enabledLastModifiedCache(request, handlerMethod)) {
            return System.currentTimeMillis();
        }
        return -1L;
    }

    protected final boolean enabledLastModifiedCache(HttpServletRequest request, Object handler) {
        if (handler == null || !(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        LastModifiedCache lastModified = (LastModifiedCache)handlerMethod.getMethodAnnotation(LastModifiedCache.class);
        if (lastModified == null) {
            if (handlerMethod.getBeanType().isAnnotation()) {
                return handlerMethod.getBeanType().getAnnotation(LastModifiedCache.class).enabled();
            }
            return false;
        }
        return lastModified.enabled();
    }
}

