/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.config;

import com.crawler.waf.filter.TokenAuthenticationProcessFilter;
import com.crawler.waf.security.authentication.PreAuthenticatedAuthenticationExtractorManager;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

public abstract class AbstractWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private PreAuthenticatedAuthenticationExtractorManager extractorManager;

    protected AbstractWebSecurityConfigurerAdapter() {
        super(true);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth, List<AuthenticationProvider> wafProviders) throws Exception {
        for (AuthenticationProvider provider : wafProviders) {
            auth.authenticationProvider(provider);
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).securityContext().and()).addFilterAfter((Filter)this.tokenAuthenticationProcessFilter(), SecurityContextPersistenceFilter.class).anonymous().and();
        this.onConfigure(http);
    }

    protected abstract void onConfigure(HttpSecurity var1) throws Exception;

    protected TokenAuthenticationProcessFilter tokenAuthenticationProcessFilter() throws Exception {
        TokenAuthenticationProcessFilter filter = new TokenAuthenticationProcessFilter(super.authenticationManager(), this.extractorManager);
        return filter;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/**"});
    }
}

