/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.config;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    private static final Pattern VERSION_PREFIX_PATTERN = Pattern.compile("v(\\d+(\\.\\d+)?)/");
    private static Map<String, List<Float>> VERSION_MAP = new HashMap<String, List<Float>>();
    private static Map<String, String> PATH_MAP = new HashMap<String, String>();
    private float apiVersion;

    public static synchronized void add(RequestMappingInfo requestMappingInfo) {
        for (String key : requestMappingInfo.getPatternsCondition().getPatterns()) {
            if (!key.contains("{version}")) {
                PATH_MAP.put(key, key.replaceAll("\\{\\w+:(.*?)\\}", "$1").replaceAll("\\{.*?\\}", "[^/]+"));
                continue;
            }
            ApiVersionCondition apiVersionCondition = (ApiVersionCondition)requestMappingInfo.getCustomCondition();
            if (apiVersionCondition == null) continue;
            float version = apiVersionCondition.getApiVersion();
            String method = "GET";
            if (requestMappingInfo.getMethodsCondition().getMethods().iterator().hasNext()) {
                method = ((RequestMethod)requestMappingInfo.getMethodsCondition().getMethods().iterator().next()).toString();
            }
            key = key + ":" + method;
            List<Object> versions = new ArrayList();
            if (VERSION_MAP.containsKey(key)) {
                versions = VERSION_MAP.get(key);
            }
            if (!versions.contains(Float.valueOf(version))) {
                versions.add(Float.valueOf(version));
            }
            Collections.sort(versions);
            Collections.reverse(versions);
            VERSION_MAP.put(key, versions);
        }
    }

    public ApiVersionCondition(float apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionCondition combine(ApiVersionCondition other) {
        return new ApiVersionCondition(other.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(HttpServletRequest request) {
        String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
        Matcher m = VERSION_PREFIX_PATTERN.matcher(path);
        if (m.find()) {
            String key;
            List<Float> versions;
            Float version = Float.valueOf(m.group(1));
            if (version.floatValue() == this.apiVersion) {
                return this;
            }
            if (version.floatValue() > this.apiVersion && (versions = this.match(key = path.replaceAll("v(\\d+(\\.\\d+)?)/", "v{version}/") + ":" + request.getMethod())) != null && versions.size() > 0) {
                int length = versions.size();
                for (int i = 0; i < length; ++i) {
                    Float upper = Float.valueOf(Float.MAX_VALUE);
                    Float lower = versions.get(i);
                    if (i > 0) {
                        upper = versions.get(i - 1);
                    }
                    if (!(version.floatValue() >= lower.floatValue()) || !(version.floatValue() < upper.floatValue()) || this.apiVersion != lower.floatValue()) continue;
                    return this;
                }
            }
        } else if (this.contains(path)) {
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionCondition other, HttpServletRequest request) {
        return other.getApiVersion() - this.apiVersion > 0.0f ? 1 : -1;
    }

    public float getApiVersion() {
        return this.apiVersion;
    }

    private boolean contains(String path) {
        for (Map.Entry<String, String> entry : PATH_MAP.entrySet()) {
            String pattern = entry.getValue();
            if (!path.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<Float> match(String key) {
        ArrayList<JSONObject> matchArray = new ArrayList<JSONObject>();
        for (Map.Entry<String, List<Float>> entry : VERSION_MAP.entrySet()) {
            String pattern = entry.getKey().replace("v{version}", "VERSION_PLACEHOLD");
            pattern = pattern.replaceAll("\\{[\\w\\.:\\\\+-]+\\}", "[\\\\w\\\\.-]+");
            pattern = pattern.replace("VERSION_PLACEHOLD", "v\\{version\\}");
            String regex = "^" + pattern + "$";
            if (!key.matches(regex)) continue;
            int placeholdCount = regex.split("\\[\\\\w\\\\.-\\]\\+").length - 1;
            JSONObject match = new JSONObject();
            match.put("key", (Object)entry.getKey());
            match.put("value", entry.getValue());
            match.put("flag", (Object)placeholdCount);
            matchArray.add(match);
        }
        if (matchArray.size() > 0) {
            if (matchArray.size() > 1) {
                Collections.sort(matchArray, new Comparator<JSONObject>(){

                    @Override
                    public int compare(JSONObject o1, JSONObject o2) {
                        return o1.getInteger("flag") - o2.getInteger("flag");
                    }
                });
            }
            return (List)((JSONObject)matchArray.get(0)).get((Object)"value");
        }
        return null;
    }
}

