/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.config;

import com.crawler.component.DateConverter;
import com.crawler.waf.exceptions.HandlerExceptionResolver;
import com.crawler.waf.exceptions.HandlerExceptionResolverBuilder;
import com.crawler.waf.exceptions.support.HttpMessageConverterUtils;
import com.crawler.waf.o2o.JacksonCustomObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.security.web.bind.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

@Configuration
@ComponentScan(basePackages={"com.crawler.waf.controllers"})
public class WafWebMvcConfigurerAdapter
extends WebMvcConfigurerAdapter {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)WafWebMvcConfigurerAdapter.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)WafWebMvcConfigurerAdapter.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)WafWebMvcConfigurerAdapter.class.getClassLoader());

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false).favorParameter(false);
        configurer.defaultContentType(MediaType.APPLICATION_JSON);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        ArrayList<MediaType> supportedMediaTypes;
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringConverter.setWriteAcceptCharset(false);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)stringConverter);
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        if (jaxb2Present) {
            Jaxb2RootElementHttpMessageConverter xmlConverter = new Jaxb2RootElementHttpMessageConverter();
            supportedMediaTypes = new ArrayList<MediaType>();
            supportedMediaTypes.add(MediaType.APPLICATION_XML);
            xmlConverter.setSupportedMediaTypes(supportedMediaTypes);
            converters.add((HttpMessageConverter<?>)xmlConverter);
        }
        if (jackson2Present) {
            MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
            messageConverter.setObjectMapper((ObjectMapper)new JacksonCustomObjectMapper());
            supportedMediaTypes = new ArrayList();
            supportedMediaTypes.add(MediaType.APPLICATION_JSON);
            messageConverter.setSupportedMediaTypes(supportedMediaTypes);
            converters.add((HttpMessageConverter<?>)messageConverter);
        }
        this.customMediaTypeSupport(converters);
    }

    public void customMediaTypeSupport(List<HttpMessageConverter<?>> converters) {
    }

    @Bean
    public HandlerExceptionResolver exceptionResolver() {
        HandlerExceptionResolverBuilder builder = HandlerExceptionResolver.builder();
        builder.setDefaultContentType(MediaType.APPLICATION_JSON);
        HandlerExceptionResolver wafResolver = builder.build();
        wafResolver.setOrder(-1);
        return wafResolver;
    }

    @Bean
    public ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        ExceptionHandlerExceptionResolver resolver = new ExceptionHandlerExceptionResolver();
        resolver.setMessageConverters(HttpMessageConverterUtils.getDefaultHttpMessageConverters());
        resolver.setOrder(-2);
        return resolver;
    }

    @Bean
    public MultipartResolver multipartResolver() {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        resolver.setDefaultEncoding("utf-8");
        resolver.setMaxUploadSize(0x500000L);
        resolver.setMaxInMemorySize(524288);
        return resolver;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
        super.addArgumentResolvers(argumentResolvers);
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new DateConverter());
        super.addFormatters(registry);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"/static/"});
        registry.addResourceHandler(new String[]{"/*.jsp"}).addResourceLocations(new String[]{"/"});
        registry.addResourceHandler(new String[]{"/*.html"}).addResourceLocations(new String[]{"/"});
        registry.addResourceHandler(new String[]{"/*.txt"}).addResourceLocations(new String[]{"/"});
        super.addResourceHandlers(registry);
    }
}

