/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.handlers;

import com.crawler.waf.exceptions.handlers.AbstractWafExceptionHandler;
import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.crawler.waf.exceptions.providers.ErrorMessageProvider;
import com.google.common.base.Throwables;
import javax.servlet.http.HttpServletRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;

public class DefaultExceptionHandler
extends AbstractWafExceptionHandler {
    private ErrorMessageProvider provider = super.getProvider();
    private String errorCode = "WAF/INTERNAL_SERVER_ERROR";

    public DefaultExceptionHandler(HttpStatus status) {
        super(status);
    }

    public DefaultExceptionHandler(HttpStatus status, String errorCode) {
        super(status);
        this.errorCode = errorCode;
    }

    public DefaultExceptionHandler(Class<?> exceptionClass) {
        super(exceptionClass);
    }

    public DefaultExceptionHandler(Class<?> exceptionClass, String errorCode) {
        super(exceptionClass);
        this.errorCode = errorCode;
    }

    public DefaultExceptionHandler(Class<?> exceptionClass, HttpStatus status, String errorCode) {
        super(exceptionClass, status);
        this.errorCode = errorCode;
    }

    @Override
    public Object createBody(Exception ex, HttpServletRequest req) {
        ErrorMessage em = this.provider.handleMessage();
        em.setCode(this.errorCode);
        this.provider.handleServerInfo(em, req);
        if (ex != null && !"".equals(ex.getMessage())) {
            if (ex instanceof DataAccessException) {
                em.setMessage("\u6570\u636e\u5e93\u5f02\u5e38");
            } else {
                em.setMessage(ex.getMessage());
            }
        } else {
            em.setMessage(super.getStatus().getReasonPhrase());
        }
        em.setStackTrace(Throwables.getStackTraceAsString((Throwable)ex));
        return em;
    }
}

