/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.support;

import com.crawler.waf.exceptions.extendExceptions.StandedException;
import com.crawler.waf.exceptions.extendExceptions.UcAuthenticationException;
import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import com.crawler.waf.exceptions.handlers.CustomExceptionHandler;
import com.crawler.waf.exceptions.handlers.DefaultExceptionHandler;
import com.crawler.waf.exceptions.handlers.ExceptionHandler;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public enum ErrorMessageMapper {
    DEFAULT_ERROR(Exception.class, new DefaultExceptionHandler(HttpStatus.INTERNAL_SERVER_ERROR)),
    NO_SUCH_REQUEST_HANDLING_METHOD(NoSuchRequestHandlingMethodException.class, new DefaultExceptionHandler(HttpStatus.NOT_FOUND, "WAF/URI_NOT_FOUND")),
    HTTP_METHOD_NOT_SUPPORTED(HttpRequestMethodNotSupportedException.class, new DefaultExceptionHandler(HttpStatus.METHOD_NOT_ALLOWED, "WAF/METHOD_NOT_ALLOWED")),
    HTTP_MEDIATYPE_NOT_SUPPORTED(HttpMediaTypeNotSupportedException.class, new DefaultExceptionHandler(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "WAF/UNSUPPORTED_MEDIA_TYPE")),
    METHOD_ARGUMENT_NOT_VALID(MethodArgumentNotValidException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/INVALID_ARGUMENT")),
    BIND_ERROR(BindException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/INVALID_ARGUMENT")),
    CONVERSION_NOT_SUPPORT(ConversionNotSupportedException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/BAD_REQUEST")),
    HTTP_MEDIATYPE_NOT_ACCEPTABLE(HttpMediaTypeNotAcceptableException.class, new DefaultExceptionHandler(HttpStatus.NOT_ACCEPTABLE, "WAF/NOT_ACCEPTABLE")),
    HTTP_MESSAGE_NOT_READABLE(HttpMessageNotReadableException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/INVALID_ARGUMENT")),
    HTTP_MESSAGE_NOT_WRITABLE(HttpMessageNotWritableException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST)),
    MISSING_REQUEST_PARAMETER(MissingServletRequestParameterException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/REQUIRE_ARGUMENT")),
    MISSING_REQUEST_PART(MissingServletRequestPartException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/REQUIRE_ARGUMENT")),
    NOT_FOUND(NoHandlerFoundException.class, new DefaultExceptionHandler(HttpStatus.NOT_FOUND, "WAF/URI_NOT_FOUND")),
    REQUEST_BIND_ERROR(ServletRequestBindingException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/BAD_REQUEST")),
    TYPE_MISMATCH(TypeMismatchException.class, new DefaultExceptionHandler(HttpStatus.BAD_REQUEST, "WAF/BAD_REQUEST")),
    ACCESS_DENIED(AccessDeniedException.class, new DefaultExceptionHandler(HttpStatus.FORBIDDEN, "WAF/ACCESS_DENIED")),
    INSUFFICIENT_AUTHENTICATION(InsufficientAuthenticationException.class, new DefaultExceptionHandler(HttpStatus.UNAUTHORIZED, "WAF/AUTH_INVALID_TOKEN")),
    WAF_AUTHENTICATION_ERROR(UcAuthenticationException.class, new CustomExceptionHandler(HttpStatus.UNAUTHORIZED)),
    AUTHENTICATION_CREDENTIAL_NOT_FOUND(AuthenticationCredentialsNotFoundException.class, new DefaultExceptionHandler(HttpStatus.UNAUTHORIZED, "WAF/AUTH_ERROR")),
    WAF_SIMPLE_ERROR(WafSimpleException.class, new CustomExceptionHandler(HttpStatus.INTERNAL_SERVER_ERROR)),
    WAF_STANDED_ERROR(StandedException.class, new CustomExceptionHandler(HttpStatus.INTERNAL_SERVER_ERROR));

    private final Class<?> exClass;
    private final ExceptionHandler handler;

    private ErrorMessageMapper(Class<?> exClass, ExceptionHandler handler) {
        this.exClass = exClass;
        this.handler = handler;
    }

    public Class<?> getExClass() {
        return this.exClass;
    }

    public ExceptionHandler getHandler() {
        return this.handler;
    }
}

