/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.filter;

import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.filter.OncePerRequestFilter;

public class ExceptionFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable ex2) {
            WafSimpleException ex2;
            if (ex2 instanceof AuthenticationException || ex2 instanceof AccessDeniedException) {
                ex2 = new WafSimpleException(HttpStatus.FORBIDDEN, "WAF/ACCESS_DENIED", "\u6388\u6743\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38");
            } else if (ex2 instanceof SQLException) {
                LOGGER.error(ex2.getMessage(), ex2);
                ex2 = new WafSimpleException("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
            } else {
                LOGGER.error(ex2.getMessage(), ex2);
            }
            request.setAttribute("exception", (Object)ex2);
            request.getRequestDispatcher("/exception").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

