/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpMethodOverrideFilter
extends OncePerRequestFilter {
    private static final String defaultCharset = "UTF-8";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block5: {
            this.logger.info("HttpMethodOverrideFilter doFilterInternal start");
            String proxyValue = request.getParameter("$proxy");
            if ("POST".equals(request.getMethod()) && "body".equals(proxyValue)) {
                String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (String)defaultCharset);
                this.logger.info("Override Method Filter bodyString" + requestBody);
                JSONObject bodyJson = null;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                HttpServletResponseWrapper httpResponseWrapper = new HttpServletResponseWrapper(response, os);
                try {
                    bodyJson = JSON.parseObject((String)requestBody);
                    if (bodyJson != null) {
                        String methodValue = bodyJson.getString("$method");
                        JSONObject headersObject = bodyJson.getJSONObject("$headers");
                        String bodyObject = bodyJson.getString("$body");
                        String method = methodValue.toUpperCase(Locale.ENGLISH);
                        HttpMethodRequestWrapper httpRequestWrapper = new HttpMethodRequestWrapper(request, method, headersObject, bodyObject);
                        filterChain.doFilter((ServletRequest)httpRequestWrapper, (ServletResponse)httpResponseWrapper);
                        this.handleResponse(os, httpResponseWrapper, response, headersObject);
                        break block5;
                    }
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    request.setAttribute("exception", (Object)new WafSimpleException(HttpStatus.PAYMENT_REQUIRED, "WAF/PROXY_PARAM_ERROR", "Parameter format is not correct"));
                    request.getRequestDispatcher("/exception").forward((ServletRequest)request, (ServletResponse)httpResponseWrapper);
                    this.handleResponse(os, httpResponseWrapper, response, null);
                }
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void handleResponse(ByteArrayOutputStream os, HttpServletResponseWrapper httpResponseWrapper, HttpServletResponse response, JSONObject headersObject) throws IOException {
        JSONObject resJSONObject = new JSONObject();
        resJSONObject.put("$headers", (Object)headersObject);
        resJSONObject.put("$status", (Object)httpResponseWrapper.getStatus());
        resJSONObject.put("$status_text", (Object)"OK");
        String body = new String(os.toByteArray(), defaultCharset);
        this.logger.info("body.length():" + body.length() + ",responseBody:" + body);
        if (!StringUtils.isEmpty((Object)body)) {
            resJSONObject.put("$body", (Object)body);
        }
        this.logger.info(httpResponseWrapper.getOutputStream().toString());
        String responseContent = resJSONObject.toString();
        response.setCharacterEncoding(defaultCharset);
        this.logger.info("resContent" + responseContent + ",response.getContentType():" + response.getContentType());
        response.setContentLength(-1);
        PrintWriter out = response.getWriter();
        out.print(resJSONObject.toString());
        out.flush();
        out.close();
    }

    private static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private OutputStream stream;

        public ServletOutputStreamWrapper(OutputStream stream) {
            this.stream = stream;
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private static class HttpServletResponseWrapper
    extends javax.servlet.http.HttpServletResponseWrapper
    implements Serializable {
        private static final long serialVersionUID = -6823255025479924073L;
        private int statusCode = 200;
        private int contentLength;
        private String contentType;
        private final List<String[]> headers = new ArrayList<String[]>();
        private final List<Cookie> cookies = new ArrayList<Cookie>();
        private ServletOutputStream servletOutputStream;
        private PrintWriter writer;

        public HttpServletResponseWrapper(HttpServletResponse response, OutputStream outputStream) {
            super(response);
            this.servletOutputStream = new ServletOutputStreamWrapper(outputStream);
        }

        public ServletOutputStream getOutputStream() {
            return this.servletOutputStream;
        }

        public void setStatus(int code) {
            this.statusCode = code;
            super.setStatus(200);
        }

        public void sendError(int i, String string) throws IOException {
            this.statusCode = i;
            super.sendError(i, string);
        }

        public void sendError(int i) throws IOException {
            this.statusCode = i;
            super.sendError(i);
        }

        public void sendRedirect(String string) throws IOException {
            this.statusCode = 302;
            super.sendRedirect(string);
        }

        public void setStatus(int code, String msg) {
            this.statusCode = code;
            super.setStatus(code);
        }

        public int getStatus() {
            return this.statusCode;
        }

        public void setContentLength(int length) {
            this.contentLength = length;
            super.setContentLength(length);
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        public String getContentType() {
            return this.contentType;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.servletOutputStream, this.getCharacterEncoding()), true);
            }
            return this.writer;
        }

        public void addHeader(String name, String value) {
            String[] header = new String[]{name, value};
            this.headers.add(header);
            super.addHeader(name, value);
        }

        public void setHeader(String name, String value) {
            this.addHeader(name, value);
        }

        public Collection<String[]> getHeaders() {
            return this.headers;
        }

        public void addCookie(Cookie cookie) {
            this.cookies.add(cookie);
            super.addCookie(cookie);
        }

        public Collection<Cookie> getCookies() {
            return this.cookies;
        }

        public void flushBuffer() throws IOException {
            this.flush();
            super.flushBuffer();
        }

        public void reset() {
            super.reset();
            this.cookies.clear();
            this.headers.clear();
            this.statusCode = 200;
            this.contentType = null;
            this.contentLength = 0;
        }

        public void resetBuffer() {
            super.resetBuffer();
        }

        public void flush() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            this.servletOutputStream.flush();
        }

        public String encodeRedirectUrl(String s) {
            return super.encodeRedirectURL(s);
        }

        public String encodeUrl(String s) {
            return super.encodeURL(s);
        }
    }

    private static class HttpMethodRequestWrapper
    extends HttpServletRequestWrapper {
        private final String method;
        private final JSONObject headers;
        private final String body;

        public HttpMethodRequestWrapper(HttpServletRequest request, String method, JSONObject headers, String body) {
            super(request);
            this.method = method;
            this.headers = headers;
            this.body = body;
        }

        public long getDateHeader(String name) {
            return this.headers.getLongValue(name);
        }

        public String getContentType() {
            return this.headers.getString("Content-Type");
        }

        public String getHeader(String name) {
            return this.headers.getString(name);
        }

        public Enumeration<String> getHeaders(String name) {
            Iterator it = this.headers.entrySet().iterator();
            LinkedList<String> values = new LinkedList<String>();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!((String)entry.getKey()).equals(name)) continue;
                values.add(entry.getValue().toString());
            }
            return Collections.enumeration(values);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public String getAuthType() {
            return super.getAuthType();
        }

        public String getCharacterEncoding() {
            return super.getCharacterEncoding();
        }

        public int getContentLength() {
            return super.getContentLength();
        }

        public int getIntHeader(String name) {
            return this.headers.getIntValue(name);
        }

        public String getMethod() {
            return this.method;
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes(HttpMethodOverrideFilter.defaultCharset));
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
    }
}

