/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.filter;

import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import com.crawler.waf.security.authentication.PreAuthenticatedAuthenticationExtractorManager;
import com.crawler.waf.security.authentication.WafAuthenticationException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationProcessFilter
extends GenericFilterBean {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AuthenticationManager authenticationManager;
    private PreAuthenticatedAuthenticationExtractorManager extractorManager;

    public TokenAuthenticationProcessFilter(AuthenticationManager authenticationManager, PreAuthenticatedAuthenticationExtractorManager extractorManager) {
        this.authenticationManager = authenticationManager;
        this.extractorManager = extractorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            authorization = request.getParameter("Authorization");
            request.removeAttribute("Authorization");
        }
        Object authException = null;
        if (authorization != null && !"".equals(authorization)) {
            long beginTime = System.currentTimeMillis();
            this.logger.info("TokenAuthenticationProcessFilter doFilter start beginTime:" + beginTime + ", authorization:" + authorization);
            try {
                Authentication authentication = this.extractorManager.extractAuthentication(authorization, request);
                Assert.notNull((Object)authentication, (String)"authentication");
                Authentication successAuthentication = this.authenticationManager.authenticate(authentication);
                SecurityContextHolder.getContext().setAuthentication(successAuthentication);
            }
            catch (AuthenticationException ex) {
                SecurityContextHolder.clearContext();
                authException = ex;
            }
            catch (Exception ex) {
                this.logger.info(ex.getMessage());
                authException = new WafAuthenticationException("\u6388\u6743\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38 " + ex.getMessage(), ex);
            }
            finally {
                long endTime = System.currentTimeMillis();
                this.logger.info("TokenAuthenticationProcessFilter doFilter end, endTime:" + endTime);
                this.logger.info("TokenAuthenticationProcessFilter doFilter the total time:" + (endTime - beginTime) + "ms");
            }
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex2) {
            if (authException != null) {
                Throwable ex2 = authException;
                if (ex2 instanceof AccessDeniedException) {
                    throw new AccessDeniedException(ex2.getMessage());
                }
                throw new WafAuthenticationException(ex2.getMessage());
            }
            if (ex2 instanceof AccessDeniedException) {
                throw new AccessDeniedException(ex2.getMessage());
            }
            this.logger.error(ex2.getMessage(), (Throwable)ex2);
            throw new WafSimpleException(ex2.getMessage());
        }
    }
}

