/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.authentication;

import com.crawler.waf.security.authentication.PreAuthenticatedAuthenticationExtractor;
import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class PreAuthenticatedAuthenticationExtractorManager {
    private ArrayList<PreAuthenticatedAuthenticationExtractor> extractors = new ArrayList();

    public void Append(PreAuthenticatedAuthenticationExtractor extractor) {
        this.extractors.add(extractor);
    }

    @Autowired
    public void appendExtractors(List<PreAuthenticatedAuthenticationExtractor> extractors) {
        this.extractors.addAll(extractors);
    }

    public Authentication extractAuthentication(String authentication, HttpServletRequest request) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"authentication");
        int spaceIndex = authentication.indexOf(" ");
        if (spaceIndex == -1) {
            throw new AuthenticationException("\u9519\u8bef\u7684 Authentication \u683c\u5f0f\uff0c\u6570\u636e\u4e3a " + authentication);
        }
        String prefix = authentication.substring(0, spaceIndex);
        String value = authentication.substring(spaceIndex).trim();
        for (PreAuthenticatedAuthenticationExtractor extractor : this.extractors) {
            if (!extractor.getPrefix().equalsIgnoreCase(prefix)) continue;
            return extractor.extractAuthentication(value, request);
        }
        throw new AuthenticationException("\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u6a21\u5f0f " + prefix);
    }
}

