/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.authentication.bearer;

import com.crawler.waf.security.authens.BaseUserInfo;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authens.UserAuthentication;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authens.UserRole;
import com.crawler.waf.security.authentication.bearer.PreAuthenticatedBearerTokenAuthentication;
import com.crawler.waf.security.services.TokenService;
import com.crawler.waf.security.services.UserDetailsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Order(value=10)
public class BearerTokenAuthenticationProvider
implements AuthenticationProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Object> bearerUserInfos = new HashMap<String, Object>();
    private UserDetailsService ucUserDetailsService;
    private TokenService ucBearerTokenService;

    @Autowired
    public void setUcUserDetailsService(UserDetailsService ucUserDetailsService) {
        this.ucUserDetailsService = ucUserDetailsService;
    }

    @Autowired
    public void setTokenService(@Qualifier(value="bearer_token_service") TokenService ucBearerTokenService) {
        this.ucBearerTokenService = ucBearerTokenService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"authentication");
        PreAuthenticatedBearerTokenAuthentication bearerTokenAuthentication = (PreAuthenticatedBearerTokenAuthentication)authentication;
        OauthAccessToken token = this.ucBearerTokenService.verifyToken((Authentication)bearerTokenAuthentication);
        UserCenterUserDetails userDetials = null;
        UserAuthentication authertication = null;
        if (token != null) {
            ArrayList<UserRole> roles = new ArrayList<UserRole>();
            UserRole roleDeatail = new UserRole();
            roleDeatail.setRoleName("ROLE_BEARER");
            roles.add(roleDeatail);
            String userId = token.getUserId();
            BaseUserInfo userInfo = (BaseUserInfo)bearerUserInfos.get(userId);
            if (userInfo == null && (userInfo = this.ucUserDetailsService.getUserInfo(userId)) != null) {
                bearerUserInfos.put(userId, userInfo);
            }
            if (userInfo != null) {
                userInfo.setUserType("Bearer");
                this.logger.info("WafAuthenticationProvider#authenticate: userId:" + userId);
                userDetials = new UserCenterUserDetails(userInfo, roles);
                authertication = new UserAuthentication(userDetials.getAuthorities());
                authertication.setAuthenticated(true);
                authertication.setDetails(userDetials);
            }
        }
        return authertication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication == PreAuthenticatedBearerTokenAuthentication.class;
    }
}

